package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(
    prefix: Optional[NonEmptyString] = Optional.Absent,
    tag: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
    ] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
      .builder()
      .optionallyWith(
        prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(
          prefix.map(value => value),
          tag.map(value => value.asEditable),
          `type`.map(value => value)
        )
    def prefix: Optional[NonEmptyString]
    def tag: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.ReadOnly
    ]
    def `type`: Optional[NonEmptyString]
    def getPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.ReadOnly
    ] = AwsError.unwrapOptionField("tag", tag)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly {
    override val prefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tag: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tag())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
          .wrap(value)
      )
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly =
    new Wrapper(impl)
}
