package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3AccountPublicAccessBlockDetails(
    blockPublicAcls: Optional[Boolean] = Optional.Absent,
    blockPublicPolicy: Optional[Boolean] = Optional.Absent,
    ignorePublicAcls: Optional[Boolean] = Optional.Absent,
    restrictPublicBuckets: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails = {
    import AwsS3AccountPublicAccessBlockDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
      .builder()
      .optionallyWith(blockPublicAcls.map(value => value: java.lang.Boolean))(
        _.blockPublicAcls
      )
      .optionallyWith(blockPublicPolicy.map(value => value: java.lang.Boolean))(
        _.blockPublicPolicy
      )
      .optionallyWith(ignorePublicAcls.map(value => value: java.lang.Boolean))(
        _.ignorePublicAcls
      )
      .optionallyWith(
        restrictPublicBuckets.map(value => value: java.lang.Boolean)
      )(_.restrictPublicBuckets)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
      .wrap(buildAwsValue())
}
object AwsS3AccountPublicAccessBlockDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails =
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails(
        blockPublicAcls.map(value => value),
        blockPublicPolicy.map(value => value),
        ignorePublicAcls.map(value => value),
        restrictPublicBuckets.map(value => value)
      )
    def blockPublicAcls: Optional[Boolean]
    def blockPublicPolicy: Optional[Boolean]
    def ignorePublicAcls: Optional[Boolean]
    def restrictPublicBuckets: Optional[Boolean]
    def getBlockPublicAcls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blockPublicAcls", blockPublicAcls)
    def getBlockPublicPolicy: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blockPublicPolicy", blockPublicPolicy)
    def getIgnorePublicAcls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignorePublicAcls", ignorePublicAcls)
    def getRestrictPublicBuckets: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("restrictPublicBuckets", restrictPublicBuckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
  ) extends zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly {
    override val blockPublicAcls: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blockPublicAcls())
      .map(value => value: Boolean)
    override val blockPublicPolicy: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blockPublicPolicy())
      .map(value => value: Boolean)
    override val ignorePublicAcls: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ignorePublicAcls())
      .map(value => value: Boolean)
    override val restrictPublicBuckets: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restrictPublicBuckets())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
  ): zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly =
    new Wrapper(impl)
}
