package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainMasterUserOptionsDetails(
    masterUserArn: Optional[NonEmptyString] = Optional.Absent,
    masterUserName: Optional[NonEmptyString] = Optional.Absent,
    masterUserPassword: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails = {
    import AwsOpenSearchServiceDomainMasterUserOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails
      .builder()
      .optionallyWith(
        masterUserArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUserArn)
      .optionallyWith(
        masterUserName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUserName)
      .optionallyWith(
        masterUserPassword.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainMasterUserOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainMasterUserOptionsDetails(
          masterUserArn.map(value => value),
          masterUserName.map(value => value),
          masterUserPassword.map(value => value)
        )
    def masterUserArn: Optional[NonEmptyString]
    def masterUserName: Optional[NonEmptyString]
    def masterUserPassword: Optional[NonEmptyString]
    def getMasterUserArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUserArn", masterUserArn)
    def getMasterUserName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUserName", masterUserName)
    def getMasterUserPassword: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails.ReadOnly {
    override val masterUserArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val masterUserName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val masterUserPassword: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserPassword())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainMasterUserOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
