package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails(
    availabilityZoneCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails = {
    import AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
      .builder()
      .optionallyWith(
        availabilityZoneCount.map(value => value: java.lang.Integer)
      )(_.availabilityZoneCount)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails(
          availabilityZoneCount.map(value => value)
        )
    def availabilityZoneCount: Optional[Integer]
    def getAvailabilityZoneCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("availabilityZoneCount", availabilityZoneCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly {
    override val availabilityZoneCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly =
    new Wrapper(impl)
}
