package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerPolicies(
    appCookieStickinessPolicies: Optional[
      Iterable[zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy]
    ] = Optional.Absent,
    lbCookieStickinessPolicies: Optional[
      Iterable[zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy]
    ] = Optional.Absent,
    otherPolicies: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies = {
    import AwsElbLoadBalancerPolicies.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
      .builder()
      .optionallyWith(
        appCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appCookieStickinessPolicies)
      .optionallyWith(
        lbCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lbCookieStickinessPolicies)
      .optionallyWith(
        otherPolicies.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.otherPolicies)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.wrap(buildAwsValue())
}
object AwsElbLoadBalancerPolicies {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerPolicies =
      zio.aws.securityhub.model.AwsElbLoadBalancerPolicies(
        appCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lbCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        otherPolicies.map(value => value)
      )
    def appCookieStickinessPolicies: Optional[
      List[zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly]
    ]
    def lbCookieStickinessPolicies: Optional[
      List[zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly]
    ]
    def otherPolicies: Optional[List[NonEmptyString]]
    def getAppCookieStickinessPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "appCookieStickinessPolicies",
      appCookieStickinessPolicies
    )
    def getLbCookieStickinessPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lbCookieStickinessPolicies",
      lbCookieStickinessPolicies
    )
    def getOtherPolicies: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("otherPolicies", otherPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly {
    override val appCookieStickinessPolicies: Optional[
      List[zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appCookieStickinessPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.wrap(item)
        }.toList
      )
    override val lbCookieStickinessPolicies: Optional[
      List[zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lbCookieStickinessPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.wrap(item)
        }.toList
      )
    override val otherPolicies: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otherPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
  ): zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly =
    new Wrapper(impl)
}
