package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(
    authorizationConfig: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
    ] = Optional.Absent,
    filesystemId: Optional[NonEmptyString] = Optional.Absent,
    rootDirectory: Optional[NonEmptyString] = Optional.Absent,
    transitEncryption: Optional[NonEmptyString] = Optional.Absent,
    transitEncryptionPort: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails = {
    import AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
      .builder()
      .optionallyWith(authorizationConfig.map(value => value.buildAwsValue()))(
        _.authorizationConfig
      )
      .optionallyWith(
        filesystemId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.filesystemId)
      .optionallyWith(
        rootDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.rootDirectory)
      .optionallyWith(
        transitEncryption.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.transitEncryption)
      .optionallyWith(
        transitEncryptionPort.map(value => value: java.lang.Integer)
      )(_.transitEncryptionPort)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(
          authorizationConfig.map(value => value.asEditable),
          filesystemId.map(value => value),
          rootDirectory.map(value => value),
          transitEncryption.map(value => value),
          transitEncryptionPort.map(value => value)
        )
    def authorizationConfig: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly
    ]
    def filesystemId: Optional[NonEmptyString]
    def rootDirectory: Optional[NonEmptyString]
    def transitEncryption: Optional[NonEmptyString]
    def transitEncryptionPort: Optional[Integer]
    def getAuthorizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("authorizationConfig", authorizationConfig)
    def getFilesystemId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filesystemId", filesystemId)
    def getRootDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
    def getTransitEncryption: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("transitEncryption", transitEncryption)
    def getTransitEncryptionPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transitEncryptionPort", transitEncryptionPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly {
    override val authorizationConfig: Optional[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizationConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
          .wrap(value)
      )
    override val filesystemId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.filesystemId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rootDirectory: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.rootDirectory())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val transitEncryption: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryption())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val transitEncryptionPort: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionPort())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
