package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(
    containerPath: Optional[NonEmptyString] = Optional.Absent,
    hostPath: Optional[NonEmptyString] = Optional.Absent,
    permissions: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
      .builder()
      .optionallyWith(
        containerPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerPath)
      .optionallyWith(
        hostPath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostPath)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(
          containerPath.map(value => value),
          hostPath.map(value => value),
          permissions.map(value => value)
        )
    def containerPath: Optional[NonEmptyString]
    def hostPath: Optional[NonEmptyString]
    def permissions: Optional[List[NonEmptyString]]
    def getContainerPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getHostPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostPath", hostPath)
    def getPermissions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("permissions", permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.ReadOnly {
    override val containerPath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hostPath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val permissions: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.ReadOnly =
    new Wrapper(impl)
}
