package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(
    options: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
      .builder()
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.options)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(
          options.map(value => value),
          `type`.map(value => value)
        )
    def options: Optional[Map[NonEmptyString, NonEmptyString]]
    def `type`: Optional[NonEmptyString]
    def getOptions: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("options", options)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly {
    override val options: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
