package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsClusterConfigurationExecuteCommandConfigurationDetails(
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    logConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
    ] = Optional.Absent,
    logging: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails = {
    import AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        logging.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.logging)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsClusterConfigurationExecuteCommandConfigurationDetails(
          kmsKeyId.map(value => value),
          logConfiguration.map(value => value.asEditable),
          logging.map(value => value)
        )
    def kmsKeyId: Optional[NonEmptyString]
    def logConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly
    ]
    def logging: Optional[NonEmptyString]
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getLogging: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("logging", logging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly {
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logConfiguration: Optional[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
          .wrap(value)
      )
    override val logging: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.logging())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
