package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkInterfaceDetails(
    attachment: Optional[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment
    ] = Optional.Absent,
    networkInterfaceId: Optional[NonEmptyString] = Optional.Absent,
    securityGroups: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup]
    ] = Optional.Absent,
    sourceDestCheck: Optional[Boolean] = Optional.Absent,
    ipV6Addresses: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
    ]] = Optional.Absent,
    privateIpAddresses: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
    ]] = Optional.Absent,
    publicDnsName: Optional[NonEmptyString] = Optional.Absent,
    publicIp: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails = {
    import AwsEc2NetworkInterfaceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(
        ipV6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipV6Addresses)
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        publicDnsName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicDnsName)
      .optionallyWith(
        publicIp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.publicIp)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails
      .wrap(buildAwsValue())
}
object AwsEc2NetworkInterfaceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails =
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails(
        attachment.map(value => value.asEditable),
        networkInterfaceId.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDestCheck.map(value => value),
        ipV6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publicDnsName.map(value => value),
        publicIp.map(value => value)
      )
    def attachment: Optional[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly
    ]
    def networkInterfaceId: Optional[NonEmptyString]
    def securityGroups: Optional[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly
    ]]
    def sourceDestCheck: Optional[Boolean]
    def ipV6Addresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly
    ]]
    def privateIpAddresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly
    ]]
    def publicDnsName: Optional[NonEmptyString]
    def publicIp: Optional[NonEmptyString]
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getIpV6Addresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("ipV6Addresses", ipV6Addresses)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getPublicDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIp", publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
  ) extends zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly {
    override val attachment: Optional[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachment())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.wrap(value)
      )
    override val networkInterfaceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val securityGroups: Optional[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup
            .wrap(item)
        }.toList
      )
    override val sourceDestCheck: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDestCheck())
      .map(value => value: Boolean)
    override val ipV6Addresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipV6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
            .wrap(item)
        }.toList
      )
    override val privateIpAddresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
            .wrap(item)
        }.toList
      )
    override val publicDnsName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.publicDnsName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publicIp: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
  ): zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly =
    new Wrapper(impl)
}
