package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails(
    max: Optional[Integer] = Optional.Absent,
    min: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails = {
    import AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
      .builder()
      .optionallyWith(max.map(value => value: java.lang.Integer))(_.max)
      .optionallyWith(min.map(value => value: java.lang.Integer))(_.min)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails(
          max.map(value => value),
          min.map(value => value)
        )
    def max: Optional[Integer]
    def min: Optional[Integer]
    def getMax: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("max", max)
    def getMin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("min", min)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.ReadOnly {
    override val max: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Integer)
    override val min: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.ReadOnly =
    new Wrapper(impl)
}
