package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataHibernationOptionsDetails(
    configured: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails = {
    import AwsEc2LaunchTemplateDataHibernationOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails
      .builder()
      .optionallyWith(configured.map(value => value: java.lang.Boolean))(
        _.configured
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataHibernationOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataHibernationOptionsDetails(
          configured.map(value => value)
        )
    def configured: Optional[Boolean]
    def getConfigured: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("configured", configured)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails.ReadOnly {
    override val configured: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.configured())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataHibernationOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
