package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails(
    capacityReservationId: Optional[NonEmptyString] = Optional.Absent,
    capacityReservationResourceGroupArn: Optional[NonEmptyString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails = {
    import AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
      .builder()
      .optionallyWith(
        capacityReservationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.capacityReservationId)
      .optionallyWith(
        capacityReservationResourceGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.capacityReservationResourceGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails(
          capacityReservationId.map(value => value),
          capacityReservationResourceGroupArn.map(value => value)
        )
    def capacityReservationId: Optional[NonEmptyString]
    def capacityReservationResourceGroupArn: Optional[NonEmptyString]
    def getCapacityReservationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getCapacityReservationResourceGroupArn
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "capacityReservationResourceGroupArn",
      capacityReservationResourceGroupArn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.ReadOnly {
    override val capacityReservationId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val capacityReservationResourceGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationResourceGroupArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.ReadOnly =
    new Wrapper(impl)
}
