package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2InstanceMetadataOptions(
    httpEndpoint: Optional[NonEmptyString] = Optional.Absent,
    httpProtocolIpv6: Optional[NonEmptyString] = Optional.Absent,
    httpPutResponseHopLimit: Optional[Integer] = Optional.Absent,
    httpTokens: Optional[NonEmptyString] = Optional.Absent,
    instanceMetadataTags: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMetadataOptions = {
    import AwsEc2InstanceMetadataOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMetadataOptions
      .builder()
      .optionallyWith(
        httpEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpEndpoint)
      .optionallyWith(
        httpProtocolIpv6.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpProtocolIpv6)
      .optionallyWith(
        httpPutResponseHopLimit.map(value => value: java.lang.Integer)
      )(_.httpPutResponseHopLimit)
      .optionallyWith(
        httpTokens.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.httpTokens)
      .optionallyWith(
        instanceMetadataTags.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceMetadataTags)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions.ReadOnly =
    zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions
      .wrap(buildAwsValue())
}
object AwsEc2InstanceMetadataOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMetadataOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions =
      zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions(
        httpEndpoint.map(value => value),
        httpProtocolIpv6.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        httpTokens.map(value => value),
        instanceMetadataTags.map(value => value)
      )
    def httpEndpoint: Optional[NonEmptyString]
    def httpProtocolIpv6: Optional[NonEmptyString]
    def httpPutResponseHopLimit: Optional[Integer]
    def httpTokens: Optional[NonEmptyString]
    def instanceMetadataTags: Optional[NonEmptyString]
    def getHttpEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpProtocolIpv6: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpTokens: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getInstanceMetadataTags: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceMetadataTags", instanceMetadataTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMetadataOptions
  ) extends zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions.ReadOnly {
    override val httpEndpoint: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.httpEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpProtocolIpv6: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpProtocolIpv6())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val httpPutResponseHopLimit: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpPutResponseHopLimit())
        .map(value => value: Integer)
    override val httpTokens: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.httpTokens())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceMetadataTags: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMetadataTags())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceMetadataOptions
  ): zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions.ReadOnly =
    new Wrapper(impl)
}
