package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFormationStackDetails(
    capabilities: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    creationTime: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    disableRollback: Optional[Boolean] = Optional.Absent,
    driftInformation: Optional[
      zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails
    ] = Optional.Absent,
    enableTerminationProtection: Optional[Boolean] = Optional.Absent,
    lastUpdatedTime: Optional[NonEmptyString] = Optional.Absent,
    notificationArns: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    outputs: Optional[
      Iterable[zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails]
    ] = Optional.Absent,
    roleArn: Optional[NonEmptyString] = Optional.Absent,
    stackId: Optional[NonEmptyString] = Optional.Absent,
    stackName: Optional[NonEmptyString] = Optional.Absent,
    stackStatus: Optional[NonEmptyString] = Optional.Absent,
    stackStatusReason: Optional[NonEmptyString] = Optional.Absent,
    timeoutInMinutes: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDetails = {
    import AwsCloudFormationStackDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDetails
      .builder()
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .optionallyWith(
        creationTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(disableRollback.map(value => value: java.lang.Boolean))(
        _.disableRollback
      )
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .optionallyWith(
        enableTerminationProtection.map(value => value: java.lang.Boolean)
      )(_.enableTerminationProtection)
      .optionallyWith(
        lastUpdatedTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedTime)
      .optionallyWith(
        notificationArns.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationArns)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        stackId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        stackName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        stackStatus.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stackStatus)
      .optionallyWith(
        stackStatusReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.stackStatusReason)
      .optionallyWith(timeoutInMinutes.map(value => value: java.lang.Integer))(
        _.timeoutInMinutes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFormationStackDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFormationStackDetails
      .wrap(buildAwsValue())
}
object AwsCloudFormationStackDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCloudFormationStackDetails =
      zio.aws.securityhub.model.AwsCloudFormationStackDetails(
        capabilities.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        disableRollback.map(value => value),
        driftInformation.map(value => value.asEditable),
        enableTerminationProtection.map(value => value),
        lastUpdatedTime.map(value => value),
        notificationArns.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn.map(value => value),
        stackId.map(value => value),
        stackName.map(value => value),
        stackStatus.map(value => value),
        stackStatusReason.map(value => value),
        timeoutInMinutes.map(value => value)
      )
    def capabilities: Optional[List[NonEmptyString]]
    def creationTime: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def disableRollback: Optional[Boolean]
    def driftInformation: Optional[
      zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails.ReadOnly
    ]
    def enableTerminationProtection: Optional[Boolean]
    def lastUpdatedTime: Optional[NonEmptyString]
    def notificationArns: Optional[List[NonEmptyString]]
    def outputs: Optional[List[
      zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails.ReadOnly
    ]]
    def roleArn: Optional[NonEmptyString]
    def stackId: Optional[NonEmptyString]
    def stackName: Optional[NonEmptyString]
    def stackStatus: Optional[NonEmptyString]
    def stackStatusReason: Optional[NonEmptyString]
    def timeoutInMinutes: Optional[Integer]
    def getCapabilities: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getCreationTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDisableRollback: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
    def getEnableTerminationProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableTerminationProtection",
        enableTerminationProtection
      )
    def getLastUpdatedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getNotificationArns: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("notificationArns", notificationArns)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStackId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getStackStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stackStatus", stackStatus)
    def getStackStatusReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stackStatusReason", stackStatusReason)
    def getTimeoutInMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDetails
  ) extends zio.aws.securityhub.model.AwsCloudFormationStackDetails.ReadOnly {
    override val capabilities: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val creationTime: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val disableRollback: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disableRollback())
      .map(value => value: Boolean)
    override val driftInformation: Optional[
      zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.driftInformation())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFormationStackDriftInformationDetails
          .wrap(value)
      )
    override val enableTerminationProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableTerminationProtection())
        .map(value => value: Boolean)
    override val lastUpdatedTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val notificationArns: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val outputs: Optional[List[
      zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails
            .wrap(item)
        }.toList
      )
    override val roleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stackId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stackName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stackStatus: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.stackStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stackStatusReason: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackStatusReason())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val timeoutInMinutes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInMinutes())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackDetails
  ): zio.aws.securityhub.model.AwsCloudFormationStackDetails.ReadOnly =
    new Wrapper(impl)
}
