package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupRecoveryPointLifecycleDetails(
    deleteAfterDays: Optional[Long] = Optional.Absent,
    moveToColdStorageAfterDays: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointLifecycleDetails = {
    import AwsBackupRecoveryPointLifecycleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointLifecycleDetails
      .builder()
      .optionallyWith(deleteAfterDays.map(value => value: java.lang.Long))(
        _.deleteAfterDays
      )
      .optionallyWith(
        moveToColdStorageAfterDays.map(value => value: java.lang.Long)
      )(_.moveToColdStorageAfterDays)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails
      .wrap(buildAwsValue())
}
object AwsBackupRecoveryPointLifecycleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointLifecycleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails =
      zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails(
        deleteAfterDays.map(value => value),
        moveToColdStorageAfterDays.map(value => value)
      )
    def deleteAfterDays: Optional[Long]
    def moveToColdStorageAfterDays: Optional[Long]
    def getDeleteAfterDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deleteAfterDays", deleteAfterDays)
    def getMoveToColdStorageAfterDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "moveToColdStorageAfterDays",
        moveToColdStorageAfterDays
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointLifecycleDetails
  ) extends zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails.ReadOnly {
    override val deleteAfterDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteAfterDays())
      .map(value => value: Long)
    override val moveToColdStorageAfterDays: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moveToColdStorageAfterDays())
        .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointLifecycleDetails
  ): zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails.ReadOnly =
    new Wrapper(impl)
}
