package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(
    deviceName: Optional[NonEmptyString] = Optional.Absent,
    ebs: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
    ] = Optional.Absent,
    noDevice: Optional[Boolean] = Optional.Absent,
    virtualName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails = {
    import AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
      .builder()
      .optionallyWith(
        deviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(ebs.map(value => value.buildAwsValue()))(_.ebs)
      .optionallyWith(noDevice.map(value => value: java.lang.Boolean))(
        _.noDevice
      )
      .optionallyWith(
        virtualName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.virtualName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(
          deviceName.map(value => value),
          ebs.map(value => value.asEditable),
          noDevice.map(value => value),
          virtualName.map(value => value)
        )
    def deviceName: Optional[NonEmptyString]
    def ebs: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.ReadOnly
    ]
    def noDevice: Optional[Boolean]
    def virtualName: Optional[NonEmptyString]
    def getDeviceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getEbs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ebs", ebs)
    def getNoDevice: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("noDevice", noDevice)
    def getVirtualName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("virtualName", virtualName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly {
    override val deviceName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ebs: Optional[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ebs())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
          .wrap(value)
      )
    override val noDevice: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.noDevice())
      .map(value => value: Boolean)
    override val virtualName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
  ): zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly =
    new Wrapper(impl)
}
