package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait AssociationStatus {
  def unwrap
      : software.amazon.awssdk.services.securityhub.model.AssociationStatus
}
object AssociationStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.AssociationStatus
  ): zio.aws.securityhub.model.AssociationStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.AssociationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.AssociationStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.securityhub.model.AssociationStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AssociationStatus =
      software.amazon.awssdk.services.securityhub.model.AssociationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.securityhub.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AssociationStatus =
      software.amazon.awssdk.services.securityhub.model.AssociationStatus.ENABLED
  }
  case object DISABLED extends zio.aws.securityhub.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AssociationStatus =
      software.amazon.awssdk.services.securityhub.model.AssociationStatus.DISABLED
  }
}
