package zio.aws.securityhub
import zio.aws.securityhub.model.DisassociateMembersResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.securityhub.{
  SecurityHubAsyncClientBuilder,
  SecurityHubAsyncClient
}
import zio.aws.securityhub.model.{
  ListSecurityControlDefinitionsRequest,
  CreateFindingAggregatorRequest,
  InviteMembersRequest,
  GetEnabledStandardsRequest,
  EnableOrganizationAdminAccountRequest,
  DisableOrganizationAdminAccountRequest,
  BatchUpdateFindingsRequest,
  DeleteActionTargetRequest,
  DisableSecurityHubRequest,
  BatchUpdateStandardsControlAssociationsRequest,
  EnableSecurityHubRequest,
  DeleteInvitationsRequest,
  DescribeProductsRequest,
  CreateActionTargetRequest,
  BatchGetSecurityControlsRequest,
  GetInsightsRequest,
  GetMembersRequest,
  ListMembersRequest,
  DescribeStandardsControlsRequest,
  UpdateStandardsControlRequest,
  DescribeActionTargetsRequest,
  BatchDeleteAutomationRulesRequest,
  BatchEnableStandardsRequest,
  BatchImportFindingsRequest,
  ListTagsForResourceRequest,
  BatchGetStandardsControlAssociationsRequest,
  GetFindingsRequest,
  CreateAutomationRuleRequest,
  UpdateFindingAggregatorRequest,
  DeleteInsightRequest,
  CreateMembersRequest,
  GetAdministratorAccountRequest,
  DescribeStandardsRequest,
  ListFindingAggregatorsRequest,
  DeclineInvitationsRequest,
  ListOrganizationAdminAccountsRequest,
  UpdateOrganizationConfigurationRequest,
  GetFindingAggregatorRequest,
  ListInvitationsRequest,
  GetFindingHistoryRequest,
  ListAutomationRulesRequest,
  BatchUpdateAutomationRulesRequest,
  UpdateInsightRequest,
  BatchDisableStandardsRequest,
  DescribeHubRequest,
  UntagResourceRequest,
  ListEnabledProductsForImportRequest,
  EnableImportFindingsForProductRequest,
  DisableImportFindingsForProductRequest,
  AcceptAdministratorInvitationRequest,
  UpdateActionTargetRequest,
  ListStandardsControlAssociationsRequest,
  GetInsightResultsRequest,
  DeleteMembersRequest,
  DeleteFindingAggregatorRequest,
  DescribeOrganizationConfigurationRequest,
  UpdateFindingsRequest,
  GetInvitationsCountRequest,
  CreateInsightRequest,
  UpdateSecurityHubConfigurationRequest,
  DisassociateFromAdministratorAccountRequest,
  TagResourceRequest,
  DisassociateMembersRequest,
  BatchGetAutomationRulesRequest
}
import software.amazon.awssdk.services.securityhub.model.{
  CreateFindingAggregatorResponse,
  AdminAccount,
  BatchUpdateAutomationRulesResponse,
  DescribeStandardsResponse,
  FindingHistoryRecord,
  AcceptAdministratorInvitationResponse,
  UpdateStandardsControlResponse,
  Invitation,
  ListStandardsControlAssociationsResponse,
  DeclineInvitationsResponse,
  GetInsightResultsResponse,
  BatchUpdateFindingsResponse,
  ListOrganizationAdminAccountsResponse,
  StandardsSubscription,
  ListMembersResponse,
  SecurityControlDefinition,
  DescribeStandardsControlsResponse,
  AutomationRulesMetadata,
  ActionTarget,
  UpdateFindingAggregatorResponse,
  DescribeProductsResponse,
  BatchEnableStandardsResponse,
  UpdateInsightResponse,
  StandardsControlAssociationSummary,
  DescribeOrganizationConfigurationResponse,
  DeleteInvitationsResponse,
  GetFindingsResponse,
  EnableImportFindingsForProductResponse,
  StandardsControl,
  AwsSecurityFinding,
  DisableOrganizationAdminAccountResponse,
  BatchDeleteAutomationRulesResponse,
  BatchUpdateStandardsControlAssociationsResponse,
  DescribeActionTargetsResponse,
  ListSecurityControlDefinitionsResponse,
  BatchImportFindingsResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteInsightResponse,
  FindingAggregator,
  BatchGetAutomationRulesResponse,
  GetEnabledStandardsResponse,
  UpdateActionTargetResponse,
  InviteMembersResponse,
  GetFindingAggregatorResponse,
  DeleteMembersResponse,
  DisableSecurityHubResponse,
  CreateMembersResponse,
  GetAdministratorAccountResponse,
  UpdateOrganizationConfigurationResponse,
  DeleteActionTargetResponse,
  DisassociateMembersResponse,
  GetMembersResponse,
  ListInvitationsResponse,
  CreateAutomationRuleResponse,
  CreateInsightResponse,
  ListAutomationRulesResponse,
  Standard,
  EnableOrganizationAdminAccountResponse,
  BatchGetStandardsControlAssociationsResponse,
  Insight,
  BatchGetSecurityControlsResponse,
  ListEnabledProductsForImportResponse,
  GetInvitationsCountResponse,
  DisableImportFindingsForProductResponse,
  DeleteFindingAggregatorResponse,
  GetFindingHistoryResponse,
  UpdateFindingsResponse,
  UpdateSecurityHubConfigurationResponse,
  DescribeHubResponse,
  BatchDisableStandardsResponse,
  TagResourceResponse,
  DisassociateFromAdministratorAccountResponse,
  Member,
  GetInsightsResponse,
  CreateActionTargetResponse,
  ListFindingAggregatorsResponse,
  EnableSecurityHubResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait SecurityHub extends AspectSupport[SecurityHub] {
  val api: SecurityHubAsyncClient
  def getFindingHistory(request: GetFindingHistoryRequest): ZStream[
    Any,
    AwsError,
    zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly
  ]
  def getFindingHistoryPaginated(
      request: GetFindingHistoryRequest
  ): IO[AwsError, zio.aws.securityhub.model.GetFindingHistoryResponse.ReadOnly]
  def getAdministratorAccount(request: GetAdministratorAccountRequest): IO[
    AwsError,
    zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly
  ]
  def batchEnableStandards(request: BatchEnableStandardsRequest): IO[
    AwsError,
    zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly
  ]
  def disableOrganizationAdminAccount(
      request: DisableOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.DisableOrganizationAdminAccountResponse.ReadOnly
  ]
  def getInsights(
      request: GetInsightsRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.Insight.ReadOnly]
  def getInsightsPaginated(
      request: GetInsightsRequest
  ): IO[AwsError, zio.aws.securityhub.model.GetInsightsResponse.ReadOnly]
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.AdminAccount.ReadOnly]
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ]
  def updateFindingAggregator(request: UpdateFindingAggregatorRequest): IO[
    AwsError,
    zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly
  ]
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ]
  def disableImportFindingsForProduct(
      request: DisableImportFindingsForProductRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.DisableImportFindingsForProductResponse.ReadOnly
  ]
  def getInvitationsCount(request: GetInvitationsCountRequest): IO[
    AwsError,
    zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly
  ]
  def batchUpdateFindings(request: BatchUpdateFindingsRequest): IO[
    AwsError,
    zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly
  ]
  def batchGetStandardsControlAssociations(
      request: BatchGetStandardsControlAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse.ReadOnly
  ]
  def updateActionTarget(
      request: UpdateActionTargetRequest
  ): IO[AwsError, zio.aws.securityhub.model.UpdateActionTargetResponse.ReadOnly]
  def describeStandards(
      request: DescribeStandardsRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.Standard.ReadOnly]
  def describeStandardsPaginated(
      request: DescribeStandardsRequest
  ): IO[AwsError, zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly]
  def listAutomationRules(request: ListAutomationRulesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.securityhub.model.AutomationRulesMetadata.ReadOnly
  ]
  def listAutomationRulesPaginated(request: ListAutomationRulesRequest): IO[
    AwsError,
    zio.aws.securityhub.model.ListAutomationRulesResponse.ReadOnly
  ]
  def batchUpdateAutomationRules(
      request: BatchUpdateAutomationRulesRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse.ReadOnly
  ]
  def disassociateMembers(
      request: DisassociateMembersRequest
  ): IO[AwsError, ReadOnly]
  def batchDisableStandards(request: BatchDisableStandardsRequest): IO[
    AwsError,
    zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly
  ]
  def deleteInsight(
      request: DeleteInsightRequest
  ): IO[AwsError, zio.aws.securityhub.model.DeleteInsightResponse.ReadOnly]
  def listMembers(
      request: ListMembersRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.Member.ReadOnly]
  def listMembersPaginated(
      request: ListMembersRequest
  ): IO[AwsError, zio.aws.securityhub.model.ListMembersResponse.ReadOnly]
  def enableImportFindingsForProduct(
      request: EnableImportFindingsForProductRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly
  ]
  def describeProducts(
      request: DescribeProductsRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.Product.ReadOnly]
  def describeProductsPaginated(
      request: DescribeProductsRequest
  ): IO[AwsError, zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly]
  def createFindingAggregator(request: CreateFindingAggregatorRequest): IO[
    AwsError,
    zio.aws.securityhub.model.CreateFindingAggregatorResponse.ReadOnly
  ]
  def batchGetSecurityControls(request: BatchGetSecurityControlsRequest): IO[
    AwsError,
    zio.aws.securityhub.model.BatchGetSecurityControlsResponse.ReadOnly
  ]
  def batchDeleteAutomationRules(
      request: BatchDeleteAutomationRulesRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.BatchDeleteAutomationRulesResponse.ReadOnly
  ]
  def listEnabledProductsForImport(
      request: ListEnabledProductsForImportRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listEnabledProductsForImportPaginated(
      request: ListEnabledProductsForImportRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly
  ]
  def inviteMembers(
      request: InviteMembersRequest
  ): IO[AwsError, zio.aws.securityhub.model.InviteMembersResponse.ReadOnly]
  def batchGetAutomationRules(request: BatchGetAutomationRulesRequest): IO[
    AwsError,
    zio.aws.securityhub.model.BatchGetAutomationRulesResponse.ReadOnly
  ]
  def acceptAdministratorInvitation(
      request: AcceptAdministratorInvitationRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.AcceptAdministratorInvitationResponse.ReadOnly
  ]
  def listSecurityControlDefinitions(
      request: ListSecurityControlDefinitionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly
  ]
  def listSecurityControlDefinitionsPaginated(
      request: ListSecurityControlDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.securityhub.model.UntagResourceResponse.ReadOnly]
  def getFindings(request: GetFindingsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly
  ]
  def getFindingsPaginated(
      request: GetFindingsRequest
  ): IO[AwsError, zio.aws.securityhub.model.GetFindingsResponse.ReadOnly]
  def updateFindings(
      request: UpdateFindingsRequest
  ): IO[AwsError, zio.aws.securityhub.model.UpdateFindingsResponse.ReadOnly]
  def createMembers(
      request: CreateMembersRequest
  ): IO[AwsError, zio.aws.securityhub.model.CreateMembersResponse.ReadOnly]
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ]
  def createActionTarget(
      request: CreateActionTargetRequest
  ): IO[AwsError, zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly]
  def createInsight(
      request: CreateInsightRequest
  ): IO[AwsError, zio.aws.securityhub.model.CreateInsightResponse.ReadOnly]
  def describeActionTargets(
      request: DescribeActionTargetsRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.ActionTarget.ReadOnly]
  def describeActionTargetsPaginated(request: DescribeActionTargetsRequest): IO[
    AwsError,
    zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly
  ]
  def enableSecurityHub(
      request: EnableSecurityHubRequest
  ): IO[AwsError, zio.aws.securityhub.model.EnableSecurityHubResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.securityhub.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.securityhub.model.TagResourceResponse.ReadOnly]
  def batchUpdateStandardsControlAssociations(
      request: BatchUpdateStandardsControlAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse.ReadOnly
  ]
  def updateStandardsControl(request: UpdateStandardsControlRequest): IO[
    AwsError,
    zio.aws.securityhub.model.UpdateStandardsControlResponse.ReadOnly
  ]
  def createAutomationRule(request: CreateAutomationRuleRequest): IO[
    AwsError,
    zio.aws.securityhub.model.CreateAutomationRuleResponse.ReadOnly
  ]
  def listFindingAggregators(request: ListFindingAggregatorsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.securityhub.model.FindingAggregator.ReadOnly
  ]
  def listFindingAggregatorsPaginated(
      request: ListFindingAggregatorsRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly
  ]
  def disableSecurityHub(
      request: DisableSecurityHubRequest
  ): IO[AwsError, zio.aws.securityhub.model.DisableSecurityHubResponse.ReadOnly]
  def listStandardsControlAssociations(
      request: ListStandardsControlAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.securityhub.model.StandardsControlAssociationSummary.ReadOnly
  ]
  def listStandardsControlAssociationsPaginated(
      request: ListStandardsControlAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.ListStandardsControlAssociationsResponse.ReadOnly
  ]
  def listInvitations(
      request: ListInvitationsRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.Invitation.ReadOnly]
  def listInvitationsPaginated(
      request: ListInvitationsRequest
  ): IO[AwsError, zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly]
  def declineInvitations(
      request: DeclineInvitationsRequest
  ): IO[AwsError, zio.aws.securityhub.model.DeclineInvitationsResponse.ReadOnly]
  def getInsightResults(
      request: GetInsightResultsRequest
  ): IO[AwsError, zio.aws.securityhub.model.GetInsightResultsResponse.ReadOnly]
  def deleteFindingAggregator(request: DeleteFindingAggregatorRequest): IO[
    AwsError,
    zio.aws.securityhub.model.DeleteFindingAggregatorResponse.ReadOnly
  ]
  def describeStandardsControls(
      request: DescribeStandardsControlsRequest
  ): ZStream[Any, AwsError, zio.aws.securityhub.model.StandardsControl.ReadOnly]
  def describeStandardsControlsPaginated(
      request: DescribeStandardsControlsRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly
  ]
  def getFindingAggregator(request: GetFindingAggregatorRequest): IO[
    AwsError,
    zio.aws.securityhub.model.GetFindingAggregatorResponse.ReadOnly
  ]
  def describeHub(
      request: DescribeHubRequest
  ): IO[AwsError, zio.aws.securityhub.model.DescribeHubResponse.ReadOnly]
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.EnableOrganizationAdminAccountResponse.ReadOnly
  ]
  def deleteInvitations(
      request: DeleteInvitationsRequest
  ): IO[AwsError, zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly]
  def batchImportFindings(request: BatchImportFindingsRequest): IO[
    AwsError,
    zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly
  ]
  def getEnabledStandards(request: GetEnabledStandardsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.securityhub.model.StandardsSubscription.ReadOnly
  ]
  def getEnabledStandardsPaginated(request: GetEnabledStandardsRequest): IO[
    AwsError,
    zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly
  ]
  def updateSecurityHubConfiguration(
      request: UpdateSecurityHubConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.UpdateSecurityHubConfigurationResponse.ReadOnly
  ]
  def deleteMembers(
      request: DeleteMembersRequest
  ): IO[AwsError, zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly]
  def disassociateFromAdministratorAccount(
      request: DisassociateFromAdministratorAccountRequest
  ): IO[
    AwsError,
    zio.aws.securityhub.model.DisassociateFromAdministratorAccountResponse.ReadOnly
  ]
  def deleteActionTarget(
      request: DeleteActionTargetRequest
  ): IO[AwsError, zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly]
  def getMembers(
      request: GetMembersRequest
  ): IO[AwsError, zio.aws.securityhub.model.GetMembersResponse.ReadOnly]
  def updateInsight(
      request: UpdateInsightRequest
  ): IO[AwsError, zio.aws.securityhub.model.UpdateInsightResponse.ReadOnly]
}
object SecurityHub {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SecurityHub] = customized(
    identity
  )
  def customized(
      customization: SecurityHubAsyncClientBuilder => SecurityHubAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SecurityHub] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SecurityHubAsyncClientBuilder => SecurityHubAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SecurityHub] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SecurityHubAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SecurityHubAsyncClient, SecurityHubAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      SecurityHubAsyncClient,
      SecurityHubAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SecurityHubImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SecurityHubImpl[R](
      override val api: SecurityHubAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SecurityHub
      with AwsServiceBase[R] {
    override val serviceName: String = "SecurityHub"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SecurityHubImpl[R1] = new SecurityHubImpl(api, newAspect, r)
    def getFindingHistory(request: GetFindingHistoryRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest,
      GetFindingHistoryResponse,
      FindingHistoryRecord
    ](
      "getFindingHistory",
      api.getFindingHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.records().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.FindingHistoryRecord.wrap(item))
      .provideEnvironment(r)
    def getFindingHistoryPaginated(request: GetFindingHistoryRequest): IO[
      AwsError,
      zio.aws.securityhub.model.GetFindingHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest,
      GetFindingHistoryResponse
    ]("getFindingHistory", api.getFindingHistory)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.GetFindingHistoryResponse.wrap)
      .provideEnvironment(r)
    def getAdministratorAccount(request: GetAdministratorAccountRequest): IO[
      AwsError,
      zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountRequest,
      GetAdministratorAccountResponse
    ]("getAdministratorAccount", api.getAdministratorAccount)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.GetAdministratorAccountResponse.wrap)
      .provideEnvironment(r)
    def batchEnableStandards(request: BatchEnableStandardsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest,
      BatchEnableStandardsResponse
    ]("batchEnableStandards", api.batchEnableStandards)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.BatchEnableStandardsResponse.wrap)
      .provideEnvironment(r)
    def disableOrganizationAdminAccount(
        request: DisableOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.DisableOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest,
      DisableOrganizationAdminAccountResponse
    ]("disableOrganizationAdminAccount", api.disableOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(
      zio.aws.securityhub.model.DisableOrganizationAdminAccountResponse.wrap
    ).provideEnvironment(r)
    def getInsights(
        request: GetInsightsRequest
    ): ZStream[Any, AwsError, zio.aws.securityhub.model.Insight.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.securityhub.model.GetInsightsRequest,
        GetInsightsResponse,
        Insight
      ](
        "getInsights",
        api.getInsights,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.insights().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.securityhub.model.Insight.wrap(item))
        .provideEnvironment(r)
    def getInsightsPaginated(
        request: GetInsightsRequest
    ): IO[AwsError, zio.aws.securityhub.model.GetInsightsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.GetInsightsRequest,
        GetInsightsResponse
      ]("getInsights", api.getInsights)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.GetInsightsResponse.wrap)
        .provideEnvironment(r)
    def listOrganizationAdminAccounts(
        request: ListOrganizationAdminAccountsRequest
    ): ZStream[Any, AwsError, zio.aws.securityhub.model.AdminAccount.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest,
        ListOrganizationAdminAccountsResponse,
        AdminAccount
      ](
        "listOrganizationAdminAccounts",
        api.listOrganizationAdminAccounts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.adminAccounts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.securityhub.model.AdminAccount.wrap(item))
        .provideEnvironment(r)
    def listOrganizationAdminAccountsPaginated(
        request: ListOrganizationAdminAccountsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest,
      ListOrganizationAdminAccountsResponse
    ]("listOrganizationAdminAccounts", api.listOrganizationAdminAccounts)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.wrap)
      .provideEnvironment(r)
    def updateFindingAggregator(request: UpdateFindingAggregatorRequest): IO[
      AwsError,
      zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest,
      UpdateFindingAggregatorResponse
    ]("updateFindingAggregator", api.updateFindingAggregator)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.UpdateFindingAggregatorResponse.wrap)
      .provideEnvironment(r)
    def updateOrganizationConfiguration(
        request: UpdateOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.UpdateOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest,
      UpdateOrganizationConfigurationResponse
    ]("updateOrganizationConfiguration", api.updateOrganizationConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.securityhub.model.UpdateOrganizationConfigurationResponse.wrap
    ).provideEnvironment(r)
    def disableImportFindingsForProduct(
        request: DisableImportFindingsForProductRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.DisableImportFindingsForProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest,
      DisableImportFindingsForProductResponse
    ]("disableImportFindingsForProduct", api.disableImportFindingsForProduct)(
      request.buildAwsValue()
    ).map(
      zio.aws.securityhub.model.DisableImportFindingsForProductResponse.wrap
    ).provideEnvironment(r)
    def getInvitationsCount(request: GetInvitationsCountRequest): IO[
      AwsError,
      zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.GetInvitationsCountRequest,
      GetInvitationsCountResponse
    ]("getInvitationsCount", api.getInvitationsCount)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.GetInvitationsCountResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateFindings(request: BatchUpdateFindingsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest,
      BatchUpdateFindingsResponse
    ]("batchUpdateFindings", api.batchUpdateFindings)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.BatchUpdateFindingsResponse.wrap)
      .provideEnvironment(r)
    def batchGetStandardsControlAssociations(
        request: BatchGetStandardsControlAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest,
      BatchGetStandardsControlAssociationsResponse
    ](
      "batchGetStandardsControlAssociations",
      api.batchGetStandardsControlAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def updateActionTarget(request: UpdateActionTargetRequest): IO[
      AwsError,
      zio.aws.securityhub.model.UpdateActionTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest,
      UpdateActionTargetResponse
    ]("updateActionTarget", api.updateActionTarget)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.UpdateActionTargetResponse.wrap)
      .provideEnvironment(r)
    def describeStandards(request: DescribeStandardsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.Standard.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest,
      DescribeStandardsResponse,
      Standard
    ](
      "describeStandards",
      api.describeStandards,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.standards().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.Standard.wrap(item))
      .provideEnvironment(r)
    def describeStandardsPaginated(request: DescribeStandardsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest,
      DescribeStandardsResponse
    ]("describeStandards", api.describeStandards)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.DescribeStandardsResponse.wrap)
      .provideEnvironment(r)
    def listAutomationRules(request: ListAutomationRulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.AutomationRulesMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest,
      ListAutomationRulesResponse,
      AutomationRulesMetadata
    ](
      "listAutomationRules",
      api.listAutomationRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.automationRulesMetadata().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.AutomationRulesMetadata.wrap(item))
      .provideEnvironment(r)
    def listAutomationRulesPaginated(request: ListAutomationRulesRequest): IO[
      AwsError,
      zio.aws.securityhub.model.ListAutomationRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest,
      ListAutomationRulesResponse
    ]("listAutomationRules", api.listAutomationRules)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.ListAutomationRulesResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateAutomationRules(
        request: BatchUpdateAutomationRulesRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest,
      BatchUpdateAutomationRulesResponse
    ]("batchUpdateAutomationRules", api.batchUpdateAutomationRules)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse.wrap)
      .provideEnvironment(r)
    def disassociateMembers(
        request: DisassociateMembersRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest,
      DisassociateMembersResponse
    ]("disassociateMembers", api.disassociateMembers)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.DisassociateMembersResponse.wrap)
      .provideEnvironment(r)
    def batchDisableStandards(request: BatchDisableStandardsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest,
      BatchDisableStandardsResponse
    ]("batchDisableStandards", api.batchDisableStandards)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.BatchDisableStandardsResponse.wrap)
      .provideEnvironment(r)
    def deleteInsight(
        request: DeleteInsightRequest
    ): IO[AwsError, zio.aws.securityhub.model.DeleteInsightResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest,
        DeleteInsightResponse
      ]("deleteInsight", api.deleteInsight)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.DeleteInsightResponse.wrap)
        .provideEnvironment(r)
    def listMembers(
        request: ListMembersRequest
    ): ZStream[Any, AwsError, zio.aws.securityhub.model.Member.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.securityhub.model.ListMembersRequest,
        ListMembersResponse,
        Member
      ](
        "listMembers",
        api.listMembers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.members().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.securityhub.model.Member.wrap(item))
        .provideEnvironment(r)
    def listMembersPaginated(
        request: ListMembersRequest
    ): IO[AwsError, zio.aws.securityhub.model.ListMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.ListMembersRequest,
        ListMembersResponse
      ]("listMembers", api.listMembers)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.ListMembersResponse.wrap)
        .provideEnvironment(r)
    def enableImportFindingsForProduct(
        request: EnableImportFindingsForProductRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest,
      EnableImportFindingsForProductResponse
    ]("enableImportFindingsForProduct", api.enableImportFindingsForProduct)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.EnableImportFindingsForProductResponse.wrap)
      .provideEnvironment(r)
    def describeProducts(request: DescribeProductsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.Product.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest,
      DescribeProductsResponse,
      software.amazon.awssdk.services.securityhub.model.Product
    ](
      "describeProducts",
      api.describeProducts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.products().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.Product.wrap(item))
      .provideEnvironment(r)
    def describeProductsPaginated(request: DescribeProductsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest,
      DescribeProductsResponse
    ]("describeProducts", api.describeProducts)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.DescribeProductsResponse.wrap)
      .provideEnvironment(r)
    def createFindingAggregator(request: CreateFindingAggregatorRequest): IO[
      AwsError,
      zio.aws.securityhub.model.CreateFindingAggregatorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest,
      CreateFindingAggregatorResponse
    ]("createFindingAggregator", api.createFindingAggregator)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.CreateFindingAggregatorResponse.wrap)
      .provideEnvironment(r)
    def batchGetSecurityControls(request: BatchGetSecurityControlsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.BatchGetSecurityControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest,
      BatchGetSecurityControlsResponse
    ]("batchGetSecurityControls", api.batchGetSecurityControls)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.BatchGetSecurityControlsResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteAutomationRules(
        request: BatchDeleteAutomationRulesRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.BatchDeleteAutomationRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest,
      BatchDeleteAutomationRulesResponse
    ]("batchDeleteAutomationRules", api.batchDeleteAutomationRules)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.BatchDeleteAutomationRulesResponse.wrap)
      .provideEnvironment(r)
    def listEnabledProductsForImport(
        request: ListEnabledProductsForImportRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest,
      ListEnabledProductsForImportResponse,
      java.lang.String
    ](
      "listEnabledProductsForImport",
      api.listEnabledProductsForImport,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.productSubscriptions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listEnabledProductsForImportPaginated(
        request: ListEnabledProductsForImportRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest,
      ListEnabledProductsForImportResponse
    ]("listEnabledProductsForImport", api.listEnabledProductsForImport)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.ListEnabledProductsForImportResponse.wrap)
      .provideEnvironment(r)
    def inviteMembers(
        request: InviteMembersRequest
    ): IO[AwsError, zio.aws.securityhub.model.InviteMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.InviteMembersRequest,
        InviteMembersResponse
      ]("inviteMembers", api.inviteMembers)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.InviteMembersResponse.wrap)
        .provideEnvironment(r)
    def batchGetAutomationRules(request: BatchGetAutomationRulesRequest): IO[
      AwsError,
      zio.aws.securityhub.model.BatchGetAutomationRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest,
      BatchGetAutomationRulesResponse
    ]("batchGetAutomationRules", api.batchGetAutomationRules)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.BatchGetAutomationRulesResponse.wrap)
      .provideEnvironment(r)
    def acceptAdministratorInvitation(
        request: AcceptAdministratorInvitationRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.AcceptAdministratorInvitationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest,
      AcceptAdministratorInvitationResponse
    ]("acceptAdministratorInvitation", api.acceptAdministratorInvitation)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.AcceptAdministratorInvitationResponse.wrap)
      .provideEnvironment(r)
    def listSecurityControlDefinitions(
        request: ListSecurityControlDefinitionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest,
      ListSecurityControlDefinitionsResponse,
      SecurityControlDefinition
    ](
      "listSecurityControlDefinitions",
      api.listSecurityControlDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.securityControlDefinitions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.securityhub.model.SecurityControlDefinition.wrap(item)
      )
      .provideEnvironment(r)
    def listSecurityControlDefinitionsPaginated(
        request: ListSecurityControlDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest,
      ListSecurityControlDefinitionsResponse
    ]("listSecurityControlDefinitions", api.listSecurityControlDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.securityhub.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getFindings(request: GetFindingsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.GetFindingsRequest,
      GetFindingsResponse,
      AwsSecurityFinding
    ](
      "getFindings",
      api.getFindings,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.findings().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.AwsSecurityFinding.wrap(item))
      .provideEnvironment(r)
    def getFindingsPaginated(
        request: GetFindingsRequest
    ): IO[AwsError, zio.aws.securityhub.model.GetFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.GetFindingsRequest,
        GetFindingsResponse
      ]("getFindings", api.getFindings)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.GetFindingsResponse.wrap)
        .provideEnvironment(r)
    def updateFindings(
        request: UpdateFindingsRequest
    ): IO[AwsError, zio.aws.securityhub.model.UpdateFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest,
        UpdateFindingsResponse
      ]("updateFindings", api.updateFindings)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.UpdateFindingsResponse.wrap)
        .provideEnvironment(r)
    def createMembers(
        request: CreateMembersRequest
    ): IO[AwsError, zio.aws.securityhub.model.CreateMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.CreateMembersRequest,
        CreateMembersResponse
      ]("createMembers", api.createMembers)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.CreateMembersResponse.wrap)
        .provideEnvironment(r)
    def describeOrganizationConfiguration(
        request: DescribeOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationRequest,
      DescribeOrganizationConfigurationResponse
    ](
      "describeOrganizationConfiguration",
      api.describeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createActionTarget(request: CreateActionTargetRequest): IO[
      AwsError,
      zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest,
      CreateActionTargetResponse
    ]("createActionTarget", api.createActionTarget)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.CreateActionTargetResponse.wrap)
      .provideEnvironment(r)
    def createInsight(
        request: CreateInsightRequest
    ): IO[AwsError, zio.aws.securityhub.model.CreateInsightResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.CreateInsightRequest,
        CreateInsightResponse
      ]("createInsight", api.createInsight)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.CreateInsightResponse.wrap)
        .provideEnvironment(r)
    def describeActionTargets(
        request: DescribeActionTargetsRequest
    ): ZStream[Any, AwsError, zio.aws.securityhub.model.ActionTarget.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest,
        DescribeActionTargetsResponse,
        ActionTarget
      ](
        "describeActionTargets",
        api.describeActionTargets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.actionTargets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.securityhub.model.ActionTarget.wrap(item))
        .provideEnvironment(r)
    def describeActionTargetsPaginated(
        request: DescribeActionTargetsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest,
      DescribeActionTargetsResponse
    ]("describeActionTargets", api.describeActionTargets)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.DescribeActionTargetsResponse.wrap)
      .provideEnvironment(r)
    def enableSecurityHub(request: EnableSecurityHubRequest): IO[
      AwsError,
      zio.aws.securityhub.model.EnableSecurityHubResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest,
      EnableSecurityHubResponse
    ]("enableSecurityHub", api.enableSecurityHub)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.EnableSecurityHubResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.securityhub.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.securityhub.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def batchUpdateStandardsControlAssociations(
        request: BatchUpdateStandardsControlAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest,
      BatchUpdateStandardsControlAssociationsResponse
    ](
      "batchUpdateStandardsControlAssociations",
      api.batchUpdateStandardsControlAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def updateStandardsControl(request: UpdateStandardsControlRequest): IO[
      AwsError,
      zio.aws.securityhub.model.UpdateStandardsControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest,
      UpdateStandardsControlResponse
    ]("updateStandardsControl", api.updateStandardsControl)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.UpdateStandardsControlResponse.wrap)
      .provideEnvironment(r)
    def createAutomationRule(request: CreateAutomationRuleRequest): IO[
      AwsError,
      zio.aws.securityhub.model.CreateAutomationRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest,
      CreateAutomationRuleResponse
    ]("createAutomationRule", api.createAutomationRule)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.CreateAutomationRuleResponse.wrap)
      .provideEnvironment(r)
    def listFindingAggregators(request: ListFindingAggregatorsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.FindingAggregator.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest,
      ListFindingAggregatorsResponse,
      FindingAggregator
    ](
      "listFindingAggregators",
      api.listFindingAggregators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.findingAggregators().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.FindingAggregator.wrap(item))
      .provideEnvironment(r)
    def listFindingAggregatorsPaginated(
        request: ListFindingAggregatorsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest,
      ListFindingAggregatorsResponse
    ]("listFindingAggregators", api.listFindingAggregators)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.ListFindingAggregatorsResponse.wrap)
      .provideEnvironment(r)
    def disableSecurityHub(request: DisableSecurityHubRequest): IO[
      AwsError,
      zio.aws.securityhub.model.DisableSecurityHubResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DisableSecurityHubRequest,
      DisableSecurityHubResponse
    ]("disableSecurityHub", api.disableSecurityHub)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.DisableSecurityHubResponse.wrap)
      .provideEnvironment(r)
    def listStandardsControlAssociations(
        request: ListStandardsControlAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.StandardsControlAssociationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest,
      ListStandardsControlAssociationsResponse,
      StandardsControlAssociationSummary
    ](
      "listStandardsControlAssociations",
      api.listStandardsControlAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.standardsControlAssociationSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.securityhub.model.StandardsControlAssociationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listStandardsControlAssociationsPaginated(
        request: ListStandardsControlAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.ListStandardsControlAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest,
      ListStandardsControlAssociationsResponse
    ]("listStandardsControlAssociations", api.listStandardsControlAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.securityhub.model.ListStandardsControlAssociationsResponse.wrap
    ).provideEnvironment(r)
    def listInvitations(request: ListInvitationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.Invitation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest,
      ListInvitationsResponse,
      Invitation
    ](
      "listInvitations",
      api.listInvitations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.invitations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.Invitation.wrap(item))
      .provideEnvironment(r)
    def listInvitationsPaginated(request: ListInvitationsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest,
      ListInvitationsResponse
    ]("listInvitations", api.listInvitations)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.ListInvitationsResponse.wrap)
      .provideEnvironment(r)
    def declineInvitations(request: DeclineInvitationsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.DeclineInvitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest,
      DeclineInvitationsResponse
    ]("declineInvitations", api.declineInvitations)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.DeclineInvitationsResponse.wrap)
      .provideEnvironment(r)
    def getInsightResults(request: GetInsightResultsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.GetInsightResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest,
      GetInsightResultsResponse
    ]("getInsightResults", api.getInsightResults)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.GetInsightResultsResponse.wrap)
      .provideEnvironment(r)
    def deleteFindingAggregator(request: DeleteFindingAggregatorRequest): IO[
      AwsError,
      zio.aws.securityhub.model.DeleteFindingAggregatorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest,
      DeleteFindingAggregatorResponse
    ]("deleteFindingAggregator", api.deleteFindingAggregator)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.DeleteFindingAggregatorResponse.wrap)
      .provideEnvironment(r)
    def describeStandardsControls(
        request: DescribeStandardsControlsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.StandardsControl.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest,
      DescribeStandardsControlsResponse,
      StandardsControl
    ](
      "describeStandardsControls",
      api.describeStandardsControls,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.controls().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.StandardsControl.wrap(item))
      .provideEnvironment(r)
    def describeStandardsControlsPaginated(
        request: DescribeStandardsControlsRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest,
      DescribeStandardsControlsResponse
    ]("describeStandardsControls", api.describeStandardsControls)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.DescribeStandardsControlsResponse.wrap)
      .provideEnvironment(r)
    def getFindingAggregator(request: GetFindingAggregatorRequest): IO[
      AwsError,
      zio.aws.securityhub.model.GetFindingAggregatorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest,
      GetFindingAggregatorResponse
    ]("getFindingAggregator", api.getFindingAggregator)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.GetFindingAggregatorResponse.wrap)
      .provideEnvironment(r)
    def describeHub(
        request: DescribeHubRequest
    ): IO[AwsError, zio.aws.securityhub.model.DescribeHubResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.DescribeHubRequest,
        DescribeHubResponse
      ]("describeHub", api.describeHub)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.DescribeHubResponse.wrap)
        .provideEnvironment(r)
    def enableOrganizationAdminAccount(
        request: EnableOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.EnableOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest,
      EnableOrganizationAdminAccountResponse
    ]("enableOrganizationAdminAccount", api.enableOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.EnableOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def deleteInvitations(request: DeleteInvitationsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest,
      DeleteInvitationsResponse
    ]("deleteInvitations", api.deleteInvitations)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.DeleteInvitationsResponse.wrap)
      .provideEnvironment(r)
    def batchImportFindings(request: BatchImportFindingsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest,
      BatchImportFindingsResponse
    ]("batchImportFindings", api.batchImportFindings)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.BatchImportFindingsResponse.wrap)
      .provideEnvironment(r)
    def getEnabledStandards(request: GetEnabledStandardsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.securityhub.model.StandardsSubscription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest,
      GetEnabledStandardsResponse,
      StandardsSubscription
    ](
      "getEnabledStandards",
      api.getEnabledStandards,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.standardsSubscriptions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.securityhub.model.StandardsSubscription.wrap(item))
      .provideEnvironment(r)
    def getEnabledStandardsPaginated(request: GetEnabledStandardsRequest): IO[
      AwsError,
      zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest,
      GetEnabledStandardsResponse
    ]("getEnabledStandards", api.getEnabledStandards)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.GetEnabledStandardsResponse.wrap)
      .provideEnvironment(r)
    def updateSecurityHubConfiguration(
        request: UpdateSecurityHubConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.UpdateSecurityHubConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest,
      UpdateSecurityHubConfigurationResponse
    ]("updateSecurityHubConfiguration", api.updateSecurityHubConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.securityhub.model.UpdateSecurityHubConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteMembers(
        request: DeleteMembersRequest
    ): IO[AwsError, zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest,
        DeleteMembersResponse
      ]("deleteMembers", api.deleteMembers)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.DeleteMembersResponse.wrap)
        .provideEnvironment(r)
    def disassociateFromAdministratorAccount(
        request: DisassociateFromAdministratorAccountRequest
    ): IO[
      AwsError,
      zio.aws.securityhub.model.DisassociateFromAdministratorAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountRequest,
      DisassociateFromAdministratorAccountResponse
    ](
      "disassociateFromAdministratorAccount",
      api.disassociateFromAdministratorAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.securityhub.model.DisassociateFromAdministratorAccountResponse.wrap
      )
      .provideEnvironment(r)
    def deleteActionTarget(request: DeleteActionTargetRequest): IO[
      AwsError,
      zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest,
      DeleteActionTargetResponse
    ]("deleteActionTarget", api.deleteActionTarget)(request.buildAwsValue())
      .map(zio.aws.securityhub.model.DeleteActionTargetResponse.wrap)
      .provideEnvironment(r)
    def getMembers(
        request: GetMembersRequest
    ): IO[AwsError, zio.aws.securityhub.model.GetMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.GetMembersRequest,
        GetMembersResponse
      ]("getMembers", api.getMembers)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.GetMembersResponse.wrap)
        .provideEnvironment(r)
    def updateInsight(
        request: UpdateInsightRequest
    ): IO[AwsError, zio.aws.securityhub.model.UpdateInsightResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest,
        UpdateInsightResponse
      ]("updateInsight", api.updateInsight)(request.buildAwsValue())
        .map(zio.aws.securityhub.model.UpdateInsightResponse.wrap)
        .provideEnvironment(r)
  }
  def getFindingHistory(request: GetFindingHistoryRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.FindingHistoryRecord.ReadOnly
  ] = ZStream.serviceWithStream(_.getFindingHistory(request))
  def getFindingHistoryPaginated(request: GetFindingHistoryRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetFindingHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingHistoryPaginated(request))
  def getAdministratorAccount(request: GetAdministratorAccountRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetAdministratorAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAdministratorAccount(request))
  def batchEnableStandards(request: BatchEnableStandardsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchEnableStandardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchEnableStandards(request))
  def disableOrganizationAdminAccount(
      request: DisableOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DisableOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableOrganizationAdminAccount(request))
  def getInsights(request: GetInsightsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.Insight.ReadOnly
  ] = ZStream.serviceWithStream(_.getInsights(request))
  def getInsightsPaginated(request: GetInsightsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsightsPaginated(request))
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.AdminAccount.ReadOnly
  ] = ZStream.serviceWithStream(_.listOrganizationAdminAccounts(request))
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrganizationAdminAccountsPaginated(request))
  def updateFindingAggregator(request: UpdateFindingAggregatorRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFindingAggregator(request))
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOrganizationConfiguration(request))
  def disableImportFindingsForProduct(
      request: DisableImportFindingsForProductRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DisableImportFindingsForProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableImportFindingsForProduct(request))
  def getInvitationsCount(request: GetInvitationsCountRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInvitationsCount(request))
  def batchUpdateFindings(request: BatchUpdateFindingsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchUpdateFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateFindings(request))
  def batchGetStandardsControlAssociations(
      request: BatchGetStandardsControlAssociationsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchGetStandardsControlAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetStandardsControlAssociations(request))
  def updateActionTarget(request: UpdateActionTargetRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UpdateActionTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateActionTarget(request))
  def describeStandards(request: DescribeStandardsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.Standard.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStandards(request))
  def describeStandardsPaginated(request: DescribeStandardsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStandardsPaginated(request))
  def listAutomationRules(request: ListAutomationRulesRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.AutomationRulesMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listAutomationRules(request))
  def listAutomationRulesPaginated(request: ListAutomationRulesRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListAutomationRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAutomationRulesPaginated(request))
  def batchUpdateAutomationRules(
      request: BatchUpdateAutomationRulesRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchUpdateAutomationRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateAutomationRules(request))
  def disassociateMembers(
      request: DisassociateMembersRequest
  ): ZIO[zio.aws.securityhub.SecurityHub, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.disassociateMembers(request))
  def batchDisableStandards(request: BatchDisableStandardsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchDisableStandardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDisableStandards(request))
  def deleteInsight(request: DeleteInsightRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DeleteInsightResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInsight(request))
  def listMembers(request: ListMembersRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.Member.ReadOnly
  ] = ZStream.serviceWithStream(_.listMembers(request))
  def listMembersPaginated(request: ListMembersRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMembersPaginated(request))
  def enableImportFindingsForProduct(
      request: EnableImportFindingsForProductRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableImportFindingsForProduct(request))
  def describeProducts(request: DescribeProductsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.Product.ReadOnly
  ] = ZStream.serviceWithStream(_.describeProducts(request))
  def describeProductsPaginated(request: DescribeProductsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DescribeProductsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProductsPaginated(request))
  def createFindingAggregator(request: CreateFindingAggregatorRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.CreateFindingAggregatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFindingAggregator(request))
  def batchGetSecurityControls(request: BatchGetSecurityControlsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchGetSecurityControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetSecurityControls(request))
  def batchDeleteAutomationRules(
      request: BatchDeleteAutomationRulesRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchDeleteAutomationRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteAutomationRules(request))
  def listEnabledProductsForImport(
      request: ListEnabledProductsForImportRequest
  ): ZStream[zio.aws.securityhub.SecurityHub, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listEnabledProductsForImport(request))
  def listEnabledProductsForImportPaginated(
      request: ListEnabledProductsForImportRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListEnabledProductsForImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnabledProductsForImportPaginated(request))
  def inviteMembers(request: InviteMembersRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.InviteMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.inviteMembers(request))
  def batchGetAutomationRules(request: BatchGetAutomationRulesRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchGetAutomationRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetAutomationRules(request))
  def acceptAdministratorInvitation(
      request: AcceptAdministratorInvitationRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.AcceptAdministratorInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptAdministratorInvitation(request))
  def listSecurityControlDefinitions(
      request: ListSecurityControlDefinitionsRequest
  ): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly
  ] = ZStream.serviceWithStream(_.listSecurityControlDefinitions(request))
  def listSecurityControlDefinitionsPaginated(
      request: ListSecurityControlDefinitionsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityControlDefinitionsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getFindings(request: GetFindingsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly
  ] = ZStream.serviceWithStream(_.getFindings(request))
  def getFindingsPaginated(request: GetFindingsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingsPaginated(request))
  def updateFindings(request: UpdateFindingsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UpdateFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFindings(request))
  def createMembers(request: CreateMembersRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.CreateMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMembers(request))
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationConfiguration(request))
  def createActionTarget(request: CreateActionTargetRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.CreateActionTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createActionTarget(request))
  def createInsight(request: CreateInsightRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.CreateInsightResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInsight(request))
  def describeActionTargets(request: DescribeActionTargetsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ActionTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.describeActionTargets(request))
  def describeActionTargetsPaginated(
      request: DescribeActionTargetsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DescribeActionTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeActionTargetsPaginated(request))
  def enableSecurityHub(request: EnableSecurityHubRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.EnableSecurityHubResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableSecurityHub(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def batchUpdateStandardsControlAssociations(
      request: BatchUpdateStandardsControlAssociationsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateStandardsControlAssociations(request))
  def updateStandardsControl(request: UpdateStandardsControlRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UpdateStandardsControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStandardsControl(request))
  def createAutomationRule(request: CreateAutomationRuleRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.CreateAutomationRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAutomationRule(request))
  def listFindingAggregators(request: ListFindingAggregatorsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.FindingAggregator.ReadOnly
  ] = ZStream.serviceWithStream(_.listFindingAggregators(request))
  def listFindingAggregatorsPaginated(
      request: ListFindingAggregatorsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingAggregatorsPaginated(request))
  def disableSecurityHub(request: DisableSecurityHubRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DisableSecurityHubResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableSecurityHub(request))
  def listStandardsControlAssociations(
      request: ListStandardsControlAssociationsRequest
  ): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.StandardsControlAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStandardsControlAssociations(request))
  def listStandardsControlAssociationsPaginated(
      request: ListStandardsControlAssociationsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListStandardsControlAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStandardsControlAssociationsPaginated(request))
  def listInvitations(request: ListInvitationsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.Invitation.ReadOnly
  ] = ZStream.serviceWithStream(_.listInvitations(request))
  def listInvitationsPaginated(request: ListInvitationsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInvitationsPaginated(request))
  def declineInvitations(request: DeclineInvitationsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DeclineInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.declineInvitations(request))
  def getInsightResults(request: GetInsightResultsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetInsightResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsightResults(request))
  def deleteFindingAggregator(request: DeleteFindingAggregatorRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DeleteFindingAggregatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFindingAggregator(request))
  def describeStandardsControls(
      request: DescribeStandardsControlsRequest
  ): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.StandardsControl.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStandardsControls(request))
  def describeStandardsControlsPaginated(
      request: DescribeStandardsControlsRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DescribeStandardsControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStandardsControlsPaginated(request))
  def getFindingAggregator(request: GetFindingAggregatorRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetFindingAggregatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingAggregator(request))
  def describeHub(request: DescribeHubRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DescribeHubResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHub(request))
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.EnableOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableOrganizationAdminAccount(request))
  def deleteInvitations(request: DeleteInvitationsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInvitations(request))
  def batchImportFindings(request: BatchImportFindingsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchImportFindings(request))
  def getEnabledStandards(request: GetEnabledStandardsRequest): ZStream[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.StandardsSubscription.ReadOnly
  ] = ZStream.serviceWithStream(_.getEnabledStandards(request))
  def getEnabledStandardsPaginated(request: GetEnabledStandardsRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnabledStandardsPaginated(request))
  def updateSecurityHubConfiguration(
      request: UpdateSecurityHubConfigurationRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UpdateSecurityHubConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecurityHubConfiguration(request))
  def deleteMembers(request: DeleteMembersRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DeleteMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMembers(request))
  def disassociateFromAdministratorAccount(
      request: DisassociateFromAdministratorAccountRequest
  ): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DisassociateFromAdministratorAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFromAdministratorAccount(request))
  def deleteActionTarget(request: DeleteActionTargetRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteActionTarget(request))
  def getMembers(request: GetMembersRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.GetMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMembers(request))
  def updateInsight(request: UpdateInsightRequest): ZIO[
    zio.aws.securityhub.SecurityHub,
    AwsError,
    zio.aws.securityhub.model.UpdateInsightResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInsight(request))
}
