package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait WorkflowStatus {
  def unwrap: software.amazon.awssdk.services.securityhub.model.WorkflowStatus
}
object WorkflowStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.WorkflowStatus
  ): zio.aws.securityhub.model.WorkflowStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.WorkflowStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowStatus.NEW =>
      val r = NEW
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowStatus.NOTIFIED =>
      val r = NOTIFIED
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowStatus.RESOLVED =>
      val r = RESOLVED
      r
    case software.amazon.awssdk.services.securityhub.model.WorkflowStatus.SUPPRESSED =>
      val r = SUPPRESSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowStatus =
      software.amazon.awssdk.services.securityhub.model.WorkflowStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NEW extends zio.aws.securityhub.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowStatus =
      software.amazon.awssdk.services.securityhub.model.WorkflowStatus.NEW
  }
  case object NOTIFIED extends zio.aws.securityhub.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowStatus =
      software.amazon.awssdk.services.securityhub.model.WorkflowStatus.NOTIFIED
  }
  case object RESOLVED extends zio.aws.securityhub.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowStatus =
      software.amazon.awssdk.services.securityhub.model.WorkflowStatus.RESOLVED
  }
  case object SUPPRESSED extends zio.aws.securityhub.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.WorkflowStatus =
      software.amazon.awssdk.services.securityhub.model.WorkflowStatus.SUPPRESSED
  }
}
