package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait VulnerabilityFixAvailable {
  def unwrap: software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable
}
object VulnerabilityFixAvailable {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable
  ): zio.aws.securityhub.model.VulnerabilityFixAvailable = value match {
    case software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.YES =>
      val r = YES
      r
    case software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.NO =>
      val r = NO
      r
    case software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.PARTIAL =>
      val r = PARTIAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.VulnerabilityFixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable =
      software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.UNKNOWN_TO_SDK_VERSION
  }
  case object YES extends zio.aws.securityhub.model.VulnerabilityFixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable =
      software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.YES
  }
  case object NO extends zio.aws.securityhub.model.VulnerabilityFixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable =
      software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.NO
  }
  case object PARTIAL
      extends zio.aws.securityhub.model.VulnerabilityFixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable =
      software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable.PARTIAL
  }
}
