package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeMount(
    name: Optional[NonEmptyString] = Optional.Absent,
    mountPath: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.VolumeMount = {
    import VolumeMount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.VolumeMount
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        mountPath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.mountPath)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.VolumeMount.ReadOnly =
    zio.aws.securityhub.model.VolumeMount.wrap(buildAwsValue())
}
object VolumeMount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.VolumeMount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.VolumeMount =
      zio.aws.securityhub.model
        .VolumeMount(name.map(value => value), mountPath.map(value => value))
    def name: Optional[NonEmptyString]
    def mountPath: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getMountPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("mountPath", mountPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.VolumeMount
  ) extends zio.aws.securityhub.model.VolumeMount.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val mountPath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.mountPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.VolumeMount
  ): zio.aws.securityhub.model.VolumeMount.ReadOnly = new Wrapper(impl)
}
