package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnprocessedStandardsControlAssociationUpdate(
    standardsControlAssociationUpdate: zio.aws.securityhub.model.StandardsControlAssociationUpdate,
    errorCode: zio.aws.securityhub.model.UnprocessedErrorCode,
    errorReason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate = {
    import UnprocessedStandardsControlAssociationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate
      .builder()
      .standardsControlAssociationUpdate(
        standardsControlAssociationUpdate.buildAwsValue()
      )
      .errorCode(errorCode.unwrap)
      .optionallyWith(
        errorReason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.errorReason)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate.ReadOnly =
    zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate
      .wrap(buildAwsValue())
}
object UnprocessedStandardsControlAssociationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate =
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate(
        standardsControlAssociationUpdate.asEditable,
        errorCode,
        errorReason.map(value => value)
      )
    def standardsControlAssociationUpdate
        : zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly
    def errorCode: zio.aws.securityhub.model.UnprocessedErrorCode
    def errorReason: Optional[NonEmptyString]
    def getStandardsControlAssociationUpdate: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly
    ] = ZIO.succeed(standardsControlAssociationUpdate)
    def getErrorCode
        : ZIO[Any, Nothing, zio.aws.securityhub.model.UnprocessedErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorReason", errorReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate
  ) extends zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate.ReadOnly {
    override val standardsControlAssociationUpdate
        : zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly =
      zio.aws.securityhub.model.StandardsControlAssociationUpdate
        .wrap(impl.standardsControlAssociationUpdate())
    override val errorCode: zio.aws.securityhub.model.UnprocessedErrorCode =
      zio.aws.securityhub.model.UnprocessedErrorCode.wrap(impl.errorCode())
    override val errorReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate
  ): zio.aws.securityhub.model.UnprocessedStandardsControlAssociationUpdate.ReadOnly =
    new Wrapper(impl)
}
