package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StatelessCustomActionDefinition(
    publishMetricAction: Optional[
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition = {
    import StatelessCustomActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
      .builder()
      .optionallyWith(publishMetricAction.map(value => value.buildAwsValue()))(
        _.publishMetricAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly =
    zio.aws.securityhub.model.StatelessCustomActionDefinition
      .wrap(buildAwsValue())
}
object StatelessCustomActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StatelessCustomActionDefinition =
      zio.aws.securityhub.model.StatelessCustomActionDefinition(
        publishMetricAction.map(value => value.asEditable)
      )
    def publishMetricAction: Optional[
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly
    ]
    def getPublishMetricAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly
    ] = AwsError.unwrapOptionField("publishMetricAction", publishMetricAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
  ) extends zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly {
    override val publishMetricAction: Optional[
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publishMetricAction())
      .map(value =>
        zio.aws.securityhub.model.StatelessCustomPublishMetricAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
  ): zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly =
    new Wrapper(impl)
}
