package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRuleDefinition(
    actions: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    matchAttributes: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleDefinition = {
    import RuleGroupSourceStatelessRuleDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleDefinition
      .builder()
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(matchAttributes.map(value => value.buildAwsValue()))(
        _.matchAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRuleDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition =
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition(
        actions.map(value => value),
        matchAttributes.map(value => value.asEditable)
      )
    def actions: Optional[List[NonEmptyString]]
    def matchAttributes: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes.ReadOnly
    ]
    def getActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("actions", actions)
    def getMatchAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("matchAttributes", matchAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleDefinition
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly {
    override val actions: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val matchAttributes: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.matchAttributes())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleDefinition
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly =
    new Wrapper(impl)
}
