package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropagatingVgwSetDetails(
    gatewayId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails = {
    import PropagatingVgwSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails
      .builder()
      .optionallyWith(
        gatewayId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PropagatingVgwSetDetails.ReadOnly =
    zio.aws.securityhub.model.PropagatingVgwSetDetails.wrap(buildAwsValue())
}
object PropagatingVgwSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PropagatingVgwSetDetails =
      zio.aws.securityhub.model
        .PropagatingVgwSetDetails(gatewayId.map(value => value))
    def gatewayId: Optional[NonEmptyString]
    def getGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails
  ) extends zio.aws.securityhub.model.PropagatingVgwSetDetails.ReadOnly {
    override val gatewayId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails
  ): zio.aws.securityhub.model.PropagatingVgwSetDetails.ReadOnly = new Wrapper(
    impl
  )
}
