package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpOrganizationDetails(
    asn: Optional[Integer] = Optional.Absent,
    asnOrg: Optional[NonEmptyString] = Optional.Absent,
    isp: Optional[NonEmptyString] = Optional.Absent,
    org: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.IpOrganizationDetails = {
    import IpOrganizationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.IpOrganizationDetails
      .builder()
      .optionallyWith(asn.map(value => value: java.lang.Integer))(_.asn)
      .optionallyWith(
        asnOrg.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.asnOrg)
      .optionallyWith(
        isp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.isp)
      .optionallyWith(
        org.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.org)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly =
    zio.aws.securityhub.model.IpOrganizationDetails.wrap(buildAwsValue())
}
object IpOrganizationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.IpOrganizationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.IpOrganizationDetails =
      zio.aws.securityhub.model.IpOrganizationDetails(
        asn.map(value => value),
        asnOrg.map(value => value),
        isp.map(value => value),
        org.map(value => value)
      )
    def asn: Optional[Integer]
    def asnOrg: Optional[NonEmptyString]
    def isp: Optional[NonEmptyString]
    def org: Optional[NonEmptyString]
    def getAsn: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("asn", asn)
    def getAsnOrg: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("asnOrg", asnOrg)
    def getIsp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("isp", isp)
    def getOrg: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("org", org)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.IpOrganizationDetails
  ) extends zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly {
    override val asn: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.asn())
      .map(value => value: Integer)
    override val asnOrg: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.asnOrg())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val isp: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.isp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val org: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.org())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.IpOrganizationDetails
  ): zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly = new Wrapper(
    impl
  )
}
