package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMembersRequest(accountIds: Iterable[NonEmptyString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest = {
    import DeleteMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest
      .builder()
      .accountIds(accountIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DeleteMembersRequest.ReadOnly =
    zio.aws.securityhub.model.DeleteMembersRequest.wrap(buildAwsValue())
}
object DeleteMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteMembersRequest =
      zio.aws.securityhub.model.DeleteMembersRequest(accountIds)
    def accountIds: List[NonEmptyString]
    def getAccountIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest
  ) extends zio.aws.securityhub.model.DeleteMembersRequest.ReadOnly {
    override val accountIds: List[NonEmptyString] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest
  ): zio.aws.securityhub.model.DeleteMembersRequest.ReadOnly = new Wrapper(impl)
}
