package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafv2CustomRequestHandlingDetails(
    insertHeaders: Optional[
      Iterable[zio.aws.securityhub.model.AwsWafv2CustomHttpHeader]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomRequestHandlingDetails = {
    import AwsWafv2CustomRequestHandlingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomRequestHandlingDetails
      .builder()
      .optionallyWith(
        insertHeaders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.insertHeaders)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails
      .wrap(buildAwsValue())
}
object AwsWafv2CustomRequestHandlingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomRequestHandlingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails =
      zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails(
        insertHeaders.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def insertHeaders: Optional[
      List[zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.ReadOnly]
    ]
    def getInsertHeaders: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("insertHeaders", insertHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomRequestHandlingDetails
  ) extends zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly {
    override val insertHeaders: Optional[
      List[zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.insertHeaders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafv2CustomHttpHeader.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomRequestHandlingDetails
  ): zio.aws.securityhub.model.AwsWafv2CustomRequestHandlingDetails.ReadOnly =
    new Wrapper(impl)
}
