package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalRuleDetails(
    metricName: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    predicateList: Optional[
      Iterable[zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails]
    ] = Optional.Absent,
    ruleId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleDetails = {
    import AwsWafRegionalRuleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleDetails
      .builder()
      .optionallyWith(
        metricName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        predicateList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predicateList)
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsWafRegionalRuleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalRuleDetails.wrap(buildAwsValue())
}
object AwsWafRegionalRuleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafRegionalRuleDetails =
      zio.aws.securityhub.model.AwsWafRegionalRuleDetails(
        metricName.map(value => value),
        name.map(value => value),
        predicateList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ruleId.map(value => value)
      )
    def metricName: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def predicateList: Optional[List[
      zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails.ReadOnly
    ]]
    def ruleId: Optional[NonEmptyString]
    def getMetricName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPredicateList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("predicateList", predicateList)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalRuleDetails.ReadOnly {
    override val metricName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val predicateList: Optional[List[
      zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.predicateList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails
            .wrap(item)
        }.toList
      )
    override val ruleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleDetails
  ): zio.aws.securityhub.model.AwsWafRegionalRuleDetails.ReadOnly = new Wrapper(
    impl
  )
}
