package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSsmPatchComplianceDetails(
    patch: Optional[zio.aws.securityhub.model.AwsSsmPatch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSsmPatchComplianceDetails = {
    import AwsSsmPatchComplianceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSsmPatchComplianceDetails
      .builder()
      .optionallyWith(patch.map(value => value.buildAwsValue()))(_.patch)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.wrap(buildAwsValue())
}
object AwsSsmPatchComplianceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSsmPatchComplianceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSsmPatchComplianceDetails =
      zio.aws.securityhub.model
        .AwsSsmPatchComplianceDetails(patch.map(value => value.asEditable))
    def patch: Optional[zio.aws.securityhub.model.AwsSsmPatch.ReadOnly]
    def getPatch
        : ZIO[Any, AwsError, zio.aws.securityhub.model.AwsSsmPatch.ReadOnly] =
      AwsError.unwrapOptionField("patch", patch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmPatchComplianceDetails
  ) extends zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.ReadOnly {
    override val patch
        : Optional[zio.aws.securityhub.model.AwsSsmPatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patch())
        .map(value => zio.aws.securityhub.model.AwsSsmPatch.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmPatchComplianceDetails
  ): zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.ReadOnly =
    new Wrapper(impl)
}
