package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketObjectLockConfigurationRuleDetails(
    defaultRetention: Optional[
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails = {
    import AwsS3BucketObjectLockConfigurationRuleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails
      .builder()
      .optionallyWith(defaultRetention.map(value => value.buildAwsValue()))(
        _.defaultRetention
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketObjectLockConfigurationRuleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails =
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails(
        defaultRetention.map(value => value.asEditable)
      )
    def defaultRetention: Optional[
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.ReadOnly
    ]
    def getDefaultRetention: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("defaultRetention", defaultRetention)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails.ReadOnly {
    override val defaultRetention: Optional[
      zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultRetention())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails
  ): zio.aws.securityhub.model.AwsS3BucketObjectLockConfigurationRuleDetails.ReadOnly =
    new Wrapper(impl)
}
