package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketLoggingConfiguration(
    destinationBucketName: Optional[NonEmptyString] = Optional.Absent,
    logFilePrefix: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketLoggingConfiguration = {
    import AwsS3BucketLoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketLoggingConfiguration
      .builder()
      .optionallyWith(
        destinationBucketName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationBucketName)
      .optionallyWith(
        logFilePrefix.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.logFilePrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration
      .wrap(buildAwsValue())
}
object AwsS3BucketLoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketLoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration =
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration(
        destinationBucketName.map(value => value),
        logFilePrefix.map(value => value)
      )
    def destinationBucketName: Optional[NonEmptyString]
    def logFilePrefix: Optional[NonEmptyString]
    def getDestinationBucketName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationBucketName", destinationBucketName)
    def getLogFilePrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("logFilePrefix", logFilePrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketLoggingConfiguration
  ) extends zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly {
    override val destinationBucketName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationBucketName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val logFilePrefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.logFilePrefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketLoggingConfiguration
  ): zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly =
    new Wrapper(impl)
}
