package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsGuardDutyDetectorDataSourcesDnsLogsDetails(
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails = {
    import AwsGuardDutyDetectorDataSourcesDnsLogsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
      .builder()
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
      .wrap(buildAwsValue())
}
object AwsGuardDutyDetectorDataSourcesDnsLogsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails =
      zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails(
        status.map(value => value)
      )
    def status: Optional[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
  ) extends zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails.ReadOnly {
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
  ): zio.aws.securityhub.model.AwsGuardDutyDetectorDataSourcesDnsLogsDetails.ReadOnly =
    new Wrapper(impl)
}
