package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(
    credentialsParameter: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
      .builder()
      .optionallyWith(
        credentialsParameter.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.credentialsParameter)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(
          credentialsParameter.map(value => value)
        )
    def credentialsParameter: Optional[NonEmptyString]
    def getCredentialsParameter: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("credentialsParameter", credentialsParameter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly {
    override val credentialsParameter: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialsParameter())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.ReadOnly =
    new Wrapper(impl)
}
