package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2TransitGatewayDetails(
    id: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    defaultRouteTablePropagation: Optional[NonEmptyString] = Optional.Absent,
    autoAcceptSharedAttachments: Optional[NonEmptyString] = Optional.Absent,
    defaultRouteTableAssociation: Optional[NonEmptyString] = Optional.Absent,
    transitGatewayCidrBlocks: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    associationDefaultRouteTableId: Optional[NonEmptyString] = Optional.Absent,
    propagationDefaultRouteTableId: Optional[NonEmptyString] = Optional.Absent,
    vpnEcmpSupport: Optional[NonEmptyString] = Optional.Absent,
    dnsSupport: Optional[NonEmptyString] = Optional.Absent,
    multicastSupport: Optional[NonEmptyString] = Optional.Absent,
    amazonSideAsn: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2TransitGatewayDetails = {
    import AwsEc2TransitGatewayDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2TransitGatewayDetails
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        defaultRouteTablePropagation.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultRouteTablePropagation)
      .optionallyWith(
        autoAcceptSharedAttachments.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.autoAcceptSharedAttachments)
      .optionallyWith(
        defaultRouteTableAssociation.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultRouteTableAssociation)
      .optionallyWith(
        transitGatewayCidrBlocks.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayCidrBlocks)
      .optionallyWith(
        associationDefaultRouteTableId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associationDefaultRouteTableId)
      .optionallyWith(
        propagationDefaultRouteTableId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.propagationDefaultRouteTableId)
      .optionallyWith(
        vpnEcmpSupport.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpnEcmpSupport)
      .optionallyWith(
        dnsSupport.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dnsSupport)
      .optionallyWith(
        multicastSupport.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.multicastSupport)
      .optionallyWith(amazonSideAsn.map(value => value: java.lang.Integer))(
        _.amazonSideAsn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2TransitGatewayDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2TransitGatewayDetails.wrap(buildAwsValue())
}
object AwsEc2TransitGatewayDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2TransitGatewayDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2TransitGatewayDetails =
      zio.aws.securityhub.model.AwsEc2TransitGatewayDetails(
        id.map(value => value),
        description.map(value => value),
        defaultRouteTablePropagation.map(value => value),
        autoAcceptSharedAttachments.map(value => value),
        defaultRouteTableAssociation.map(value => value),
        transitGatewayCidrBlocks.map(value => value),
        associationDefaultRouteTableId.map(value => value),
        propagationDefaultRouteTableId.map(value => value),
        vpnEcmpSupport.map(value => value),
        dnsSupport.map(value => value),
        multicastSupport.map(value => value),
        amazonSideAsn.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def defaultRouteTablePropagation: Optional[NonEmptyString]
    def autoAcceptSharedAttachments: Optional[NonEmptyString]
    def defaultRouteTableAssociation: Optional[NonEmptyString]
    def transitGatewayCidrBlocks: Optional[List[NonEmptyString]]
    def associationDefaultRouteTableId: Optional[NonEmptyString]
    def propagationDefaultRouteTableId: Optional[NonEmptyString]
    def vpnEcmpSupport: Optional[NonEmptyString]
    def dnsSupport: Optional[NonEmptyString]
    def multicastSupport: Optional[NonEmptyString]
    def amazonSideAsn: Optional[Integer]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultRouteTablePropagation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "defaultRouteTablePropagation",
        defaultRouteTablePropagation
      )
    def getAutoAcceptSharedAttachments: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "autoAcceptSharedAttachments",
        autoAcceptSharedAttachments
      )
    def getDefaultRouteTableAssociation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "defaultRouteTableAssociation",
        defaultRouteTableAssociation
      )
    def getTransitGatewayCidrBlocks: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "transitGatewayCidrBlocks",
        transitGatewayCidrBlocks
      )
    def getAssociationDefaultRouteTableId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "associationDefaultRouteTableId",
        associationDefaultRouteTableId
      )
    def getPropagationDefaultRouteTableId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "propagationDefaultRouteTableId",
        propagationDefaultRouteTableId
      )
    def getVpnEcmpSupport: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpnEcmpSupport", vpnEcmpSupport)
    def getDnsSupport: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dnsSupport", dnsSupport)
    def getMulticastSupport: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("multicastSupport", multicastSupport)
    def getAmazonSideAsn: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2TransitGatewayDetails
  ) extends zio.aws.securityhub.model.AwsEc2TransitGatewayDetails.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultRouteTablePropagation: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRouteTablePropagation())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val autoAcceptSharedAttachments: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoAcceptSharedAttachments())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val defaultRouteTableAssociation: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRouteTableAssociation())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val transitGatewayCidrBlocks: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayCidrBlocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val associationDefaultRouteTableId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationDefaultRouteTableId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val propagationDefaultRouteTableId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagationDefaultRouteTableId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val vpnEcmpSupport: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnEcmpSupport())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val dnsSupport: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsSupport())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val multicastSupport: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multicastSupport())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val amazonSideAsn: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonSideAsn())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2TransitGatewayDetails
  ): zio.aws.securityhub.model.AwsEc2TransitGatewayDetails.ReadOnly =
    new Wrapper(impl)
}
