package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2RouteTableDetails(
    associationSet: Optional[
      Iterable[zio.aws.securityhub.model.AssociationSetDetails]
    ] = Optional.Absent,
    ownerId: Optional[NonEmptyString] = Optional.Absent,
    propagatingVgwSet: Optional[
      Iterable[zio.aws.securityhub.model.PropagatingVgwSetDetails]
    ] = Optional.Absent,
    routeTableId: Optional[NonEmptyString] = Optional.Absent,
    routeSet: Optional[Iterable[zio.aws.securityhub.model.RouteSetDetails]] =
      Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2RouteTableDetails = {
    import AwsEc2RouteTableDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2RouteTableDetails
      .builder()
      .optionallyWith(
        associationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associationSet)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        propagatingVgwSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propagatingVgwSet)
      .optionallyWith(
        routeTableId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.routeTableId)
      .optionallyWith(
        routeSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routeSet)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2RouteTableDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2RouteTableDetails.wrap(buildAwsValue())
}
object AwsEc2RouteTableDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2RouteTableDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2RouteTableDetails =
      zio.aws.securityhub.model.AwsEc2RouteTableDetails(
        associationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        propagatingVgwSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        routeTableId.map(value => value),
        routeSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def associationSet: Optional[
      List[zio.aws.securityhub.model.AssociationSetDetails.ReadOnly]
    ]
    def ownerId: Optional[NonEmptyString]
    def propagatingVgwSet: Optional[
      List[zio.aws.securityhub.model.PropagatingVgwSetDetails.ReadOnly]
    ]
    def routeTableId: Optional[NonEmptyString]
    def routeSet
        : Optional[List[zio.aws.securityhub.model.RouteSetDetails.ReadOnly]]
    def vpcId: Optional[NonEmptyString]
    def getAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AssociationSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("associationSet", associationSet)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPropagatingVgwSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.PropagatingVgwSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("propagatingVgwSet", propagatingVgwSet)
    def getRouteTableId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getRouteSet: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RouteSetDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("routeSet", routeSet)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2RouteTableDetails
  ) extends zio.aws.securityhub.model.AwsEc2RouteTableDetails.ReadOnly {
    override val associationSet: Optional[
      List[zio.aws.securityhub.model.AssociationSetDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AssociationSetDetails.wrap(item)
        }.toList
      )
    override val ownerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val propagatingVgwSet: Optional[
      List[zio.aws.securityhub.model.PropagatingVgwSetDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propagatingVgwSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.PropagatingVgwSetDetails.wrap(item)
        }.toList
      )
    override val routeTableId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val routeSet
        : Optional[List[zio.aws.securityhub.model.RouteSetDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.RouteSetDetails.wrap(item)
          }.toList
        )
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2RouteTableDetails
  ): zio.aws.securityhub.model.AwsEc2RouteTableDetails.ReadOnly = new Wrapper(
    impl
  )
}
