package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails(
    ipv4Prefix: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails = {
    import AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
      .builder()
      .optionallyWith(
        ipv4Prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipv4Prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails(
          ipv4Prefix.map(value => value)
        )
    def ipv4Prefix: Optional[NonEmptyString]
    def getIpv4Prefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipv4Prefix", ipv4Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.ReadOnly {
    override val ipv4Prefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.ReadOnly =
    new Wrapper(impl)
}
