package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataMetadataOptionsDetails(
    httpEndpoint: Optional[NonEmptyString] = Optional.Absent,
    httpProtocolIpv6: Optional[NonEmptyString] = Optional.Absent,
    httpTokens: Optional[NonEmptyString] = Optional.Absent,
    httpPutResponseHopLimit: Optional[Integer] = Optional.Absent,
    instanceMetadataTags: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails = {
    import AwsEc2LaunchTemplateDataMetadataOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails
      .builder()
      .optionallyWith(
        httpEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpEndpoint)
      .optionallyWith(
        httpProtocolIpv6.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpProtocolIpv6)
      .optionallyWith(
        httpTokens.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.httpTokens)
      .optionallyWith(
        httpPutResponseHopLimit.map(value => value: java.lang.Integer)
      )(_.httpPutResponseHopLimit)
      .optionallyWith(
        instanceMetadataTags.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceMetadataTags)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataMetadataOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails =
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails(
        httpEndpoint.map(value => value),
        httpProtocolIpv6.map(value => value),
        httpTokens.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        instanceMetadataTags.map(value => value)
      )
    def httpEndpoint: Optional[NonEmptyString]
    def httpProtocolIpv6: Optional[NonEmptyString]
    def httpTokens: Optional[NonEmptyString]
    def httpPutResponseHopLimit: Optional[Integer]
    def instanceMetadataTags: Optional[NonEmptyString]
    def getHttpEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpProtocolIpv6: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
    def getHttpTokens: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getInstanceMetadataTags: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceMetadataTags", instanceMetadataTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails.ReadOnly {
    override val httpEndpoint: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.httpEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpProtocolIpv6: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpProtocolIpv6())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val httpTokens: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.httpTokens())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpPutResponseHopLimit: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpPutResponseHopLimit())
        .map(value => value: Integer)
    override val instanceMetadataTags: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMetadataTags())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataMetadataOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
