package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataInstanceRequirementsDetails(
    acceleratorCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails
    ] = Optional.Absent,
    acceleratorManufacturers: Optional[Iterable[NonEmptyString]] =
      Optional.Absent,
    acceleratorNames: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    acceleratorTotalMemoryMiB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
    ] = Optional.Absent,
    acceleratorTypes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    bareMetal: Optional[NonEmptyString] = Optional.Absent,
    baselineEbsBandwidthMbps: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails
    ] = Optional.Absent,
    burstablePerformance: Optional[NonEmptyString] = Optional.Absent,
    cpuManufacturers: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    excludedInstanceTypes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    instanceGenerations: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    localStorage: Optional[NonEmptyString] = Optional.Absent,
    localStorageTypes: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    memoryGiBPerVCpu: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails
    ] = Optional.Absent,
    memoryMiB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
    ] = Optional.Absent,
    networkInterfaceCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails
    ] = Optional.Absent,
    onDemandMaxPricePercentageOverLowestPrice: Optional[Integer] =
      Optional.Absent,
    requireHibernateSupport: Optional[Boolean] = Optional.Absent,
    spotMaxPricePercentageOverLowestPrice: Optional[Integer] = Optional.Absent,
    totalLocalStorageGB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
    ] = Optional.Absent,
    vCpuCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails = {
    import AwsEc2LaunchTemplateDataInstanceRequirementsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
      .builder()
      .optionallyWith(acceleratorCount.map(value => value.buildAwsValue()))(
        _.acceleratorCount
      )
      .optionallyWith(
        acceleratorManufacturers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.acceleratorManufacturers)
      .optionallyWith(
        acceleratorNames.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.acceleratorNames)
      .optionallyWith(
        acceleratorTotalMemoryMiB.map(value => value.buildAwsValue())
      )(_.acceleratorTotalMemoryMiB)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.acceleratorTypes)
      .optionallyWith(
        bareMetal.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bareMetal)
      .optionallyWith(
        baselineEbsBandwidthMbps.map(value => value.buildAwsValue())
      )(_.baselineEbsBandwidthMbps)
      .optionallyWith(
        burstablePerformance.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.burstablePerformance)
      .optionallyWith(
        cpuManufacturers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cpuManufacturers)
      .optionallyWith(
        excludedInstanceTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedInstanceTypes)
      .optionallyWith(
        instanceGenerations.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceGenerations)
      .optionallyWith(
        localStorage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.localStorage)
      .optionallyWith(
        localStorageTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.localStorageTypes)
      .optionallyWith(memoryGiBPerVCpu.map(value => value.buildAwsValue()))(
        _.memoryGiBPerVCpu
      )
      .optionallyWith(memoryMiB.map(value => value.buildAwsValue()))(
        _.memoryMiB
      )
      .optionallyWith(
        networkInterfaceCount.map(value => value.buildAwsValue())
      )(_.networkInterfaceCount)
      .optionallyWith(
        onDemandMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.onDemandMaxPricePercentageOverLowestPrice)
      .optionallyWith(
        requireHibernateSupport.map(value => value: java.lang.Boolean)
      )(_.requireHibernateSupport)
      .optionallyWith(
        spotMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.spotMaxPricePercentageOverLowestPrice)
      .optionallyWith(totalLocalStorageGB.map(value => value.buildAwsValue()))(
        _.totalLocalStorageGB
      )
      .optionallyWith(vCpuCount.map(value => value.buildAwsValue()))(
        _.vCpuCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataInstanceRequirementsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataInstanceRequirementsDetails(
          acceleratorCount.map(value => value.asEditable),
          acceleratorManufacturers.map(value => value),
          acceleratorNames.map(value => value),
          acceleratorTotalMemoryMiB.map(value => value.asEditable),
          acceleratorTypes.map(value => value),
          bareMetal.map(value => value),
          baselineEbsBandwidthMbps.map(value => value.asEditable),
          burstablePerformance.map(value => value),
          cpuManufacturers.map(value => value),
          excludedInstanceTypes.map(value => value),
          instanceGenerations.map(value => value),
          localStorage.map(value => value),
          localStorageTypes.map(value => value),
          memoryGiBPerVCpu.map(value => value.asEditable),
          memoryMiB.map(value => value.asEditable),
          networkInterfaceCount.map(value => value.asEditable),
          onDemandMaxPricePercentageOverLowestPrice.map(value => value),
          requireHibernateSupport.map(value => value),
          spotMaxPricePercentageOverLowestPrice.map(value => value),
          totalLocalStorageGB.map(value => value.asEditable),
          vCpuCount.map(value => value.asEditable)
        )
    def acceleratorCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.ReadOnly
    ]
    def acceleratorManufacturers: Optional[List[NonEmptyString]]
    def acceleratorNames: Optional[List[NonEmptyString]]
    def acceleratorTotalMemoryMiB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.ReadOnly
    ]
    def acceleratorTypes: Optional[List[NonEmptyString]]
    def bareMetal: Optional[NonEmptyString]
    def baselineEbsBandwidthMbps: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.ReadOnly
    ]
    def burstablePerformance: Optional[NonEmptyString]
    def cpuManufacturers: Optional[List[NonEmptyString]]
    def excludedInstanceTypes: Optional[List[NonEmptyString]]
    def instanceGenerations: Optional[List[NonEmptyString]]
    def localStorage: Optional[NonEmptyString]
    def localStorageTypes: Optional[List[NonEmptyString]]
    def memoryGiBPerVCpu: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.ReadOnly
    ]
    def memoryMiB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.ReadOnly
    ]
    def networkInterfaceCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.ReadOnly
    ]
    def onDemandMaxPricePercentageOverLowestPrice: Optional[Integer]
    def requireHibernateSupport: Optional[Boolean]
    def spotMaxPricePercentageOverLowestPrice: Optional[Integer]
    def totalLocalStorageGB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.ReadOnly
    ]
    def vCpuCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.ReadOnly
    ]
    def getAcceleratorCount: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.ReadOnly
    ] = AwsError.unwrapOptionField("acceleratorCount", acceleratorCount)
    def getAcceleratorManufacturers: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "acceleratorManufacturers",
        acceleratorManufacturers
      )
    def getAcceleratorNames: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("acceleratorNames", acceleratorNames)
    def getAcceleratorTotalMemoryMiB: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "acceleratorTotalMemoryMiB",
      acceleratorTotalMemoryMiB
    )
    def getAcceleratorTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getBareMetal: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bareMetal", bareMetal)
    def getBaselineEbsBandwidthMbps: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "baselineEbsBandwidthMbps",
      baselineEbsBandwidthMbps
    )
    def getBurstablePerformance: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("burstablePerformance", burstablePerformance)
    def getCpuManufacturers: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("cpuManufacturers", cpuManufacturers)
    def getExcludedInstanceTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("excludedInstanceTypes", excludedInstanceTypes)
    def getInstanceGenerations: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("instanceGenerations", instanceGenerations)
    def getLocalStorage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("localStorage", localStorage)
    def getLocalStorageTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("localStorageTypes", localStorageTypes)
    def getMemoryGiBPerVCpu: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.ReadOnly
    ] = AwsError.unwrapOptionField("memoryGiBPerVCpu", memoryGiBPerVCpu)
    def getMemoryMiB: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.ReadOnly
    ] = AwsError.unwrapOptionField("memoryMiB", memoryMiB)
    def getNetworkInterfaceCount: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("networkInterfaceCount", networkInterfaceCount)
    def getOnDemandMaxPricePercentageOverLowestPrice
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "onDemandMaxPricePercentageOverLowestPrice",
      onDemandMaxPricePercentageOverLowestPrice
    )
    def getRequireHibernateSupport: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("requireHibernateSupport", requireHibernateSupport)
    def getSpotMaxPricePercentageOverLowestPrice: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "spotMaxPricePercentageOverLowestPrice",
        spotMaxPricePercentageOverLowestPrice
      )
    def getTotalLocalStorageGB: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.ReadOnly
    ] = AwsError.unwrapOptionField("totalLocalStorageGB", totalLocalStorageGB)
    def getVCpuCount: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.ReadOnly
    ] = AwsError.unwrapOptionField("vCpuCount", vCpuCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails.ReadOnly {
    override val acceleratorCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorCount())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails
          .wrap(value)
      )
    override val acceleratorManufacturers: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorManufacturers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val acceleratorNames: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val acceleratorTotalMemoryMiB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorTotalMemoryMiB())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
          .wrap(value)
      )
    override val acceleratorTypes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val bareMetal: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bareMetal())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val baselineEbsBandwidthMbps: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineEbsBandwidthMbps())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails
          .wrap(value)
      )
    override val burstablePerformance: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.burstablePerformance())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val cpuManufacturers: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuManufacturers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val excludedInstanceTypes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val instanceGenerations: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGenerations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val localStorage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.localStorage())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val localStorageTypes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localStorageTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val memoryGiBPerVCpu: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryGiBPerVCpu())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails
          .wrap(value)
      )
    override val memoryMiB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryMiB())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
          .wrap(value)
      )
    override val networkInterfaceCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceCount())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails
          .wrap(value)
      )
    override val onDemandMaxPricePercentageOverLowestPrice: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandMaxPricePercentageOverLowestPrice())
        .map(value => value: Integer)
    override val requireHibernateSupport: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requireHibernateSupport())
        .map(value => value: Boolean)
    override val spotMaxPricePercentageOverLowestPrice: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotMaxPricePercentageOverLowestPrice())
        .map(value => value: Integer)
    override val totalLocalStorageGB: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.totalLocalStorageGB())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
          .wrap(value)
      )
    override val vCpuCount: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vCpuCount())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails.ReadOnly =
    new Wrapper(impl)
}
