package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableSseDescription(
    inaccessibleEncryptionDateTime: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    sseType: Optional[NonEmptyString] = Optional.Absent,
    kmsMasterKeyArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableSseDescription = {
    import AwsDynamoDbTableSseDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableSseDescription
      .builder()
      .optionallyWith(
        inaccessibleEncryptionDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.inaccessibleEncryptionDateTime)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        sseType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sseType)
      .optionallyWith(
        kmsMasterKeyArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableSseDescription
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableSseDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableSseDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableSseDescription =
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription(
        inaccessibleEncryptionDateTime.map(value => value),
        status.map(value => value),
        sseType.map(value => value),
        kmsMasterKeyArn.map(value => value)
      )
    def inaccessibleEncryptionDateTime: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def sseType: Optional[NonEmptyString]
    def kmsMasterKeyArn: Optional[NonEmptyString]
    def getInaccessibleEncryptionDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "inaccessibleEncryptionDateTime",
        inaccessibleEncryptionDateTime
      )
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getSseType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sseType", sseType)
    def getKmsMasterKeyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsMasterKeyArn", kmsMasterKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableSseDescription
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly {
    override val inaccessibleEncryptionDateTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inaccessibleEncryptionDateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sseType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sseType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsMasterKeyArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsMasterKeyArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableSseDescription
  ): zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly =
    new Wrapper(impl)
}
