package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(
    groupName: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    streamName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails = {
    import AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
      .builder()
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        streamName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.streamName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails =
      zio.aws.securityhub.model
        .AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(
          groupName.map(value => value),
          status.map(value => value),
          streamName.map(value => value)
        )
    def groupName: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def streamName: Optional[NonEmptyString]
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getStreamName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("streamName", streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly {
    override val groupName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val streamName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly =
    new Wrapper(impl)
}
