package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupVaultDetails(
    backupVaultArn: Optional[NonEmptyString] = Optional.Absent,
    backupVaultName: Optional[NonEmptyString] = Optional.Absent,
    encryptionKeyArn: Optional[NonEmptyString] = Optional.Absent,
    notifications: Optional[
      zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails
    ] = Optional.Absent,
    accessPolicy: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultDetails = {
    import AwsBackupBackupVaultDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultDetails
      .builder()
      .optionallyWith(
        backupVaultArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupVaultArn)
      .optionallyWith(
        backupVaultName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        encryptionKeyArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .optionallyWith(notifications.map(value => value.buildAwsValue()))(
        _.notifications
      )
      .optionallyWith(
        accessPolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupVaultDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupVaultDetails.wrap(buildAwsValue())
}
object AwsBackupBackupVaultDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsBackupBackupVaultDetails =
      zio.aws.securityhub.model.AwsBackupBackupVaultDetails(
        backupVaultArn.map(value => value),
        backupVaultName.map(value => value),
        encryptionKeyArn.map(value => value),
        notifications.map(value => value.asEditable),
        accessPolicy.map(value => value)
      )
    def backupVaultArn: Optional[NonEmptyString]
    def backupVaultName: Optional[NonEmptyString]
    def encryptionKeyArn: Optional[NonEmptyString]
    def notifications: Optional[
      zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails.ReadOnly
    ]
    def accessPolicy: Optional[NonEmptyString]
    def getBackupVaultArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getBackupVaultName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getEncryptionKeyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getNotifications: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("notifications", notifications)
    def getAccessPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessPolicy", accessPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupVaultDetails.ReadOnly {
    override val backupVaultArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val backupVaultName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val encryptionKeyArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val notifications: Optional[
      zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notifications())
      .map(value =>
        zio.aws.securityhub.model.AwsBackupBackupVaultNotificationsDetails
          .wrap(value)
      )
    override val accessPolicy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPolicy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupVaultDetails
  ): zio.aws.securityhub.model.AwsBackupBackupVaultDetails.ReadOnly =
    new Wrapper(impl)
}
