package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupPlanDetails(
    backupPlan: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails
    ] = Optional.Absent,
    backupPlanArn: Optional[NonEmptyString] = Optional.Absent,
    backupPlanId: Optional[NonEmptyString] = Optional.Absent,
    versionId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanDetails = {
    import AwsBackupBackupPlanDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanDetails
      .builder()
      .optionallyWith(backupPlan.map(value => value.buildAwsValue()))(
        _.backupPlan
      )
      .optionallyWith(
        backupPlanArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupPlanArn)
      .optionallyWith(
        backupPlanId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupPlanId)
      .optionallyWith(
        versionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupPlanDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupPlanDetails.wrap(buildAwsValue())
}
object AwsBackupBackupPlanDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsBackupBackupPlanDetails =
      zio.aws.securityhub.model.AwsBackupBackupPlanDetails(
        backupPlan.map(value => value.asEditable),
        backupPlanArn.map(value => value),
        backupPlanId.map(value => value),
        versionId.map(value => value)
      )
    def backupPlan: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails.ReadOnly
    ]
    def backupPlanArn: Optional[NonEmptyString]
    def backupPlanId: Optional[NonEmptyString]
    def versionId: Optional[NonEmptyString]
    def getBackupPlan: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails.ReadOnly
    ] = AwsError.unwrapOptionField("backupPlan", backupPlan)
    def getBackupPlanArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getBackupPlanId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getVersionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupPlanDetails.ReadOnly {
    override val backupPlan: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlan())
      .map(value =>
        zio.aws.securityhub.model.AwsBackupBackupPlanBackupPlanDetails
          .wrap(value)
      )
    override val backupPlanArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val backupPlanId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val versionId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanDetails
  ): zio.aws.securityhub.model.AwsBackupBackupPlanDetails.ReadOnly =
    new Wrapper(impl)
}
