package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociationSetDetails(
    associationState: Optional[
      zio.aws.securityhub.model.AssociationStateDetails
    ] = Optional.Absent,
    gatewayId: Optional[NonEmptyString] = Optional.Absent,
    main: Optional[Boolean] = Optional.Absent,
    routeTableAssociationId: Optional[NonEmptyString] = Optional.Absent,
    routeTableId: Optional[NonEmptyString] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AssociationSetDetails = {
    import AssociationSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AssociationSetDetails
      .builder()
      .optionallyWith(associationState.map(value => value.buildAwsValue()))(
        _.associationState
      )
      .optionallyWith(
        gatewayId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(main.map(value => value: java.lang.Boolean))(_.main)
      .optionallyWith(
        routeTableAssociationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.routeTableAssociationId)
      .optionallyWith(
        routeTableId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.routeTableId)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AssociationSetDetails.ReadOnly =
    zio.aws.securityhub.model.AssociationSetDetails.wrap(buildAwsValue())
}
object AssociationSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AssociationSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AssociationSetDetails =
      zio.aws.securityhub.model.AssociationSetDetails(
        associationState.map(value => value.asEditable),
        gatewayId.map(value => value),
        main.map(value => value),
        routeTableAssociationId.map(value => value),
        routeTableId.map(value => value),
        subnetId.map(value => value)
      )
    def associationState
        : Optional[zio.aws.securityhub.model.AssociationStateDetails.ReadOnly]
    def gatewayId: Optional[NonEmptyString]
    def main: Optional[Boolean]
    def routeTableAssociationId: Optional[NonEmptyString]
    def routeTableId: Optional[NonEmptyString]
    def subnetId: Optional[NonEmptyString]
    def getAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AssociationStateDetails.ReadOnly
    ] = AwsError.unwrapOptionField("associationState", associationState)
    def getGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getMain: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("main", main)
    def getRouteTableAssociationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "routeTableAssociationId",
        routeTableAssociationId
      )
    def getRouteTableId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AssociationSetDetails
  ) extends zio.aws.securityhub.model.AssociationSetDetails.ReadOnly {
    override val associationState
        : Optional[zio.aws.securityhub.model.AssociationStateDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationState())
        .map(value =>
          zio.aws.securityhub.model.AssociationStateDetails.wrap(value)
        )
    override val gatewayId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val main: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.main())
      .map(value => value: Boolean)
    override val routeTableAssociationId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTableAssociationId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val routeTableId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AssociationSetDetails
  ): zio.aws.securityhub.model.AssociationSetDetails.ReadOnly = new Wrapper(
    impl
  )
}
