package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Threat(
    name: Optional[NonEmptyString] = Optional.Absent,
    severity: Optional[NonEmptyString] = Optional.Absent,
    itemCount: Optional[Integer] = Optional.Absent,
    filePaths: Optional[Iterable[zio.aws.securityhub.model.FilePaths]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Threat = {
    import Threat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Threat
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        severity.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .optionallyWith(
        filePaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filePaths)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Threat.ReadOnly =
    zio.aws.securityhub.model.Threat.wrap(buildAwsValue())
}
object Threat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Threat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Threat =
      zio.aws.securityhub.model.Threat(
        name.map(value => value),
        severity.map(value => value),
        itemCount.map(value => value),
        filePaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[NonEmptyString]
    def severity: Optional[NonEmptyString]
    def itemCount: Optional[Integer]
    def filePaths: Optional[List[zio.aws.securityhub.model.FilePaths.ReadOnly]]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("severity", severity)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getFilePaths: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FilePaths.ReadOnly
    ]] = AwsError.unwrapOptionField("filePaths", filePaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Threat
  ) extends zio.aws.securityhub.model.Threat.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val severity: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val itemCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Integer)
    override val filePaths
        : Optional[List[zio.aws.securityhub.model.FilePaths.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filePaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.FilePaths.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Threat
  ): zio.aws.securityhub.model.Threat.ReadOnly = new Wrapper(impl)
}
