package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SoftwarePackage(
    name: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    epoch: Optional[NonEmptyString] = Optional.Absent,
    release: Optional[NonEmptyString] = Optional.Absent,
    architecture: Optional[NonEmptyString] = Optional.Absent,
    packageManager: Optional[NonEmptyString] = Optional.Absent,
    filePath: Optional[NonEmptyString] = Optional.Absent,
    fixedInVersion: Optional[NonEmptyString] = Optional.Absent,
    remediation: Optional[NonEmptyString] = Optional.Absent,
    sourceLayerHash: Optional[NonEmptyString] = Optional.Absent,
    sourceLayerArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SoftwarePackage = {
    import SoftwarePackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SoftwarePackage
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        epoch.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.epoch)
      .optionallyWith(
        release.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.release)
      .optionallyWith(
        architecture.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.architecture)
      .optionallyWith(
        packageManager.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.packageManager)
      .optionallyWith(
        filePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        fixedInVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fixedInVersion)
      .optionallyWith(
        remediation.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.remediation)
      .optionallyWith(
        sourceLayerHash.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceLayerHash)
      .optionallyWith(
        sourceLayerArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceLayerArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SoftwarePackage.ReadOnly =
    zio.aws.securityhub.model.SoftwarePackage.wrap(buildAwsValue())
}
object SoftwarePackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SoftwarePackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SoftwarePackage =
      zio.aws.securityhub.model.SoftwarePackage(
        name.map(value => value),
        version.map(value => value),
        epoch.map(value => value),
        release.map(value => value),
        architecture.map(value => value),
        packageManager.map(value => value),
        filePath.map(value => value),
        fixedInVersion.map(value => value),
        remediation.map(value => value),
        sourceLayerHash.map(value => value),
        sourceLayerArn.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def epoch: Optional[NonEmptyString]
    def release: Optional[NonEmptyString]
    def architecture: Optional[NonEmptyString]
    def packageManager: Optional[NonEmptyString]
    def filePath: Optional[NonEmptyString]
    def fixedInVersion: Optional[NonEmptyString]
    def remediation: Optional[NonEmptyString]
    def sourceLayerHash: Optional[NonEmptyString]
    def sourceLayerArn: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getEpoch: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getRelease: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("release", release)
    def getArchitecture: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getPackageManager: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packageManager", packageManager)
    def getFilePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getFixedInVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fixedInVersion", fixedInVersion)
    def getRemediation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("remediation", remediation)
    def getSourceLayerHash: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceLayerHash", sourceLayerHash)
    def getSourceLayerArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceLayerArn", sourceLayerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SoftwarePackage
  ) extends zio.aws.securityhub.model.SoftwarePackage.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val epoch: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.epoch())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val release: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.release())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val architecture: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val packageManager: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageManager())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val filePath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val fixedInVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixedInVersion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val remediation: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.remediation())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceLayerHash: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLayerHash())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val sourceLayerArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLayerArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SoftwarePackage
  ): zio.aws.securityhub.model.SoftwarePackage.ReadOnly = new Wrapper(impl)
}
