package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSecurityControlDefinitionsResponse(
    securityControlDefinitions: Iterable[
      zio.aws.securityhub.model.SecurityControlDefinition
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse = {
    import ListSecurityControlDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse
      .builder()
      .securityControlDefinitions(securityControlDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse.ReadOnly =
    zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListSecurityControlDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse =
      zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse(
        securityControlDefinitions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def securityControlDefinitions
        : List[zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly]
    def nextToken: Optional[NextToken]
    def getSecurityControlDefinitions: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly
    ]] = ZIO.succeed(securityControlDefinitions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse
  ) extends zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse.ReadOnly {
    override val securityControlDefinitions
        : List[zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly] =
      impl
        .securityControlDefinitions()
        .asScala
        .map { item =>
          zio.aws.securityhub.model.SecurityControlDefinition.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse
  ): zio.aws.securityhub.model.ListSecurityControlDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
