package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetFindingsRequest(
    filters: Optional[zio.aws.securityhub.model.AwsSecurityFindingFilters] =
      Optional.Absent,
    sortCriteria: Optional[Iterable[zio.aws.securityhub.model.SortCriterion]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetFindingsRequest = {
    import GetFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        sortCriteria.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortCriteria)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetFindingsRequest.ReadOnly =
    zio.aws.securityhub.model.GetFindingsRequest.wrap(buildAwsValue())
}
object GetFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetFindingsRequest =
      zio.aws.securityhub.model.GetFindingsRequest(
        filters.map(value => value.asEditable),
        sortCriteria.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters
        : Optional[zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly]
    def sortCriteria
        : Optional[List[zio.aws.securityhub.model.SortCriterion.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getSortCriteria: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.SortCriterion.ReadOnly
    ]] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
  ) extends zio.aws.securityhub.model.GetFindingsRequest.ReadOnly {
    override val filters: Optional[
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(value)
      )
    override val sortCriteria
        : Optional[List[zio.aws.securityhub.model.SortCriterion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.SortCriterion.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingsRequest
  ): zio.aws.securityhub.model.GetFindingsRequest.ReadOnly = new Wrapper(impl)
}
