package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait FindingHistoryUpdateSourceType {
  def unwrap: software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType
}
object FindingHistoryUpdateSourceType {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType
  ): zio.aws.securityhub.model.FindingHistoryUpdateSourceType = value match {
    case software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType.BATCH_UPDATE_FINDINGS =>
      val r = BATCH_UPDATE_FINDINGS
      r
    case software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType.BATCH_IMPORT_FINDINGS =>
      val r = BATCH_IMPORT_FINDINGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.FindingHistoryUpdateSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType =
      software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object BATCH_UPDATE_FINDINGS
      extends zio.aws.securityhub.model.FindingHistoryUpdateSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType =
      software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType.BATCH_UPDATE_FINDINGS
  }
  case object BATCH_IMPORT_FINDINGS
      extends zio.aws.securityhub.model.FindingHistoryUpdateSourceType {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType =
      software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSourceType.BATCH_IMPORT_FINDINGS
  }
}
